/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.net.URL;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

final class EHCacheUtil {
    private static boolean useCreateNewMethod;

    private EHCacheUtil() {
    }

    static CacheManager createCacheManager() throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance();
        }
        return CacheManager.create();
    }

    static CacheManager createCacheManager(String configurationFileName) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance((String)configurationFileName);
        }
        return CacheManager.create((String)configurationFileName);
    }

    static CacheManager createCacheManager(URL configurationFileURL) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance((URL)configurationFileURL);
        }
        return CacheManager.create((URL)configurationFileURL);
    }

    static CacheManager createCacheManager(InputStream inputStream) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance((InputStream)inputStream);
        }
        return CacheManager.create((InputStream)inputStream);
    }

    static CacheManager createCacheManager(Configuration conf) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance((Configuration)conf);
        }
        return CacheManager.create((Configuration)conf);
    }

    static {
        try {
            CacheManager.class.getMethod("newInstance", null);
            useCreateNewMethod = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

