/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.OneToMany;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BindyAbstractFactory
implements BindyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BindyAbstractFactory.class);
    protected final Map<String, List<Field>> annotatedLinkFields = new LinkedHashMap<String, List<Field>>();
    protected FormatFactory formatFactory;
    protected Set<Class<?>> models;
    protected Set<String> modelClassNames;
    protected String crlf;
    protected String eol;
    private String locale;
    private Class<?> type;

    protected BindyAbstractFactory(Class<?> type) throws Exception {
        this.type = type;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class name: {}", (Object)type.getName());
        }
        this.initModel();
    }

    @Override
    public void initModel() throws Exception {
        this.models = new HashSet();
        this.modelClassNames = new HashSet<String>();
        this.loadModels(this.type);
    }

    private void loadModels(Class<?> root) {
        this.models.add(root);
        this.modelClassNames.add(root.getName());
        for (Field field : root.getDeclaredFields()) {
            OneToMany oneToManyField;
            Link linkField = field.getAnnotation(Link.class);
            if (linkField != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class linked: {}, Field: {}", field.getType(), (Object)field);
                }
                this.models.add(field.getType());
                this.modelClassNames.add(field.getType().getName());
                this.loadModels(field.getType());
            }
            if ((oneToManyField = field.getAnnotation(OneToMany.class)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Class (OneToMany) linked: {}, Field: {}", field.getType(), (Object)field);
            }
            Type listType = field.getGenericType();
            Type type = ((ParameterizedType)listType).getActualTypeArguments()[0];
            Class clazz = (Class)type;
            this.models.add(clazz);
            this.modelClassNames.add(clazz.getName());
            this.loadModels(clazz);
        }
    }

    public abstract void initAnnotatedFields() throws Exception;

    @Override
    public abstract void bind(CamelContext var1, List<String> var2, Map<String, Object> var3, int var4) throws Exception;

    @Override
    public abstract String unbind(CamelContext var1, Map<String, Object> var2) throws Exception;

    public void link(Map<String, Object> model) {
        for (Map.Entry<String, List<Field>> entry : this.annotatedLinkFields.entrySet()) {
            List<Field> linkFields = entry.getValue();
            for (Field field : linkFields) {
                String toClassName = field.getType().getName();
                Object to = model.get(toClassName);
                ObjectHelper.notNull((Object)to, (String)"No @link annotation has been defined for the object to link");
                ReflectionHelper.setField((Field)field, (Object)model.get(field.getDeclaringClass().getName()), (Object)to);
            }
        }
    }

    public Map<String, Object> factory() throws Exception {
        HashMap<String, Object> mapModel = new HashMap<String, Object>();
        for (Class<?> cl : this.models) {
            Object obj = org.apache.camel.support.ObjectHelper.newInstance(cl);
            mapModel.put(obj.getClass().getName(), obj);
        }
        return mapModel;
    }

    public boolean supportsModel(Set<String> classes) {
        return this.modelClassNames.containsAll(classes);
    }

    protected static Integer generateKey(Integer key1, Integer key2) {
        if (key1 == null || key2 == null) {
            throw new IllegalArgumentException("@Section and/or @KeyValuePairDataField have not been defined");
        }
        String key2Formatted = BindyAbstractFactory.getNumberFormat().format(key2.intValue());
        String keyGenerated = String.valueOf(key1) + key2Formatted;
        return Integer.valueOf(keyGenerated);
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(3);
        nf.setMinimumIntegerDigits(3);
        return nf;
    }

    public static Object getDefaultValueForPrimitive(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return (byte)-128;
        }
        if (clazz == Short.TYPE) {
            return (short)Short.MIN_VALUE;
        }
        if (clazz == Integer.TYPE) {
            return Integer.MIN_VALUE;
        }
        if (clazz == Long.TYPE) {
            return Long.MIN_VALUE;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        if (clazz == Double.TYPE) {
            return Double.MIN_VALUE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == String.class) {
            return "";
        }
        return null;
    }

    public String getCarriageReturn() {
        return this.crlf;
    }

    public String getEndOfLine() {
        return this.eol;
    }

    public String formatString(Format<?> format, Object value) throws Exception {
        String strValue = "";
        if (value != null) {
            try {
                strValue = format.format(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Formatting error detected for the value: " + String.valueOf(value), e);
            }
        }
        return strValue;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setFormatFactory(FormatFactory formatFactory) {
        this.formatFactory = formatFactory;
    }
}

