/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.format.NumberPatternFormat;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class LongPatternFormatFactory
extends AbstractFormatFactory {
    public LongPatternFormatFactory() {
        this.supportedClasses.add(Long.TYPE);
        this.supportedClasses.add(Long.class);
    }

    @Override
    public boolean canBuild(FormattingOptions formattingOptions) {
        return super.canBuild(formattingOptions) && ObjectHelper.isNotEmpty((Object)formattingOptions.getPattern());
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new LongPatternFormat(formattingOptions.getPattern(), formattingOptions.getLocale());
    }

    private static class LongPatternFormat
    extends NumberPatternFormat<Long> {
        LongPatternFormat(String pattern, Locale locale) {
            super(pattern, locale);
        }

        @Override
        public Long parse(String string) throws Exception {
            if (this.getNumberFormat() != null) {
                return this.getNumberFormat().parse(string).longValue();
            }
            return Long.valueOf(string);
        }
    }
}

