/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.builder.ExpressionBuilder;

public final class DefaultParameterMappingStrategy
implements ParameterMappingStrategy {
    public static final DefaultParameterMappingStrategy INSTANCE = new DefaultParameterMappingStrategy();
    private static final Map<Class<?>, Expression> MAP = new HashMap(6);

    private DefaultParameterMappingStrategy() {
    }

    @Override
    public Expression getDefaultParameterTypeExpression(Class<?> parameterType) {
        return MAP.get(parameterType);
    }

    static {
        MAP.put(Exchange.class, ExpressionBuilder.exchangeExpression());
        MAP.put(Message.class, ExpressionBuilder.inMessageExpression());
        MAP.put(Exception.class, ExpressionBuilder.exchangeExceptionExpression());
        MAP.put(TypeConverter.class, ExpressionBuilder.typeConverterExpression());
        MAP.put(Registry.class, ExpressionBuilder.registryExpression());
        MAP.put(CamelContext.class, ExpressionBuilder.camelContextExpression());
    }
}

