/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.IsSingleton;
import org.apache.camel.NonManagedService;
import org.apache.camel.Service;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePool<S extends Service>
extends ServiceSupport
implements NonManagedService {
    static final Logger LOG = LoggerFactory.getLogger(ServicePool.class);
    final ThrowingFunction<Endpoint, S, Exception> producer;
    final Function<S, Endpoint> getEndpoint;
    final ConcurrentHashMap<Endpoint, Pool<S>> pool = new ConcurrentHashMap();
    int capacity;
    Map<Key<S>, S> cache;

    public ServicePool(ThrowingFunction<Endpoint, S, Exception> producer, Function<S, Endpoint> getEndpoint, int capacity) {
        this.producer = producer;
        this.getEndpoint = getEndpoint;
        this.capacity = capacity;
        this.cache = capacity > 0 ? LRUCacheFactory.newLRUCache((int)capacity, this::onEvict) : null;
    }

    protected void onEvict(S s) {
        Endpoint e = this.getEndpoint.apply(s);
        Pool<S> p = this.pool.get(e);
        if (p != null) {
            if (p.evict(s)) {
                this.pool.remove(e);
            }
        } else {
            ServicePool.stop(s);
            try {
                e.getCamelContext().removeService(s);
            }
            catch (Exception ex) {
                LOG.error("Error removing service {}", s, (Object)ex);
            }
        }
    }

    public S acquire(Endpoint endpoint) throws Exception {
        if (!this.isStarted()) {
            return null;
        }
        Service s = (Service)this.getPool(endpoint).acquire();
        if (s != null && this.cache != null) {
            this.cache.putIfAbsent(new Key<Service>(s), s);
        }
        return (S)s;
    }

    public void release(Endpoint endpoint, S s) {
        this.getPool(endpoint).release(s);
    }

    protected Pool<S> getPool(Endpoint endpoint) {
        return this.pool.computeIfAbsent(endpoint, this::createPool);
    }

    private Pool<S> createPool(Endpoint endpoint) {
        boolean singleton = endpoint.isSingleton();
        try {
            Service s = (Service)this.producer.apply((Object)endpoint);
            if (s instanceof IsSingleton) {
                singleton = ((IsSingleton)s).isSingleton();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (singleton && this.capacity > 0) {
            return new SinglePool(endpoint);
        }
        return new MultiplePool(endpoint);
    }

    public int size() {
        return this.pool.values().stream().mapToInt(Pool::size).sum();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.pool.values().forEach(Pool::stop);
        this.pool.clear();
    }

    public void cleanUp() {
        if (this.cache instanceof LRUCache) {
            ((LRUCache)this.cache).cleanUp();
        }
    }

    public void resetStatistics() {
        if (this.cache instanceof LRUCache) {
            ((LRUCache)this.cache).resetStatistics();
        }
    }

    public long getEvicted() {
        if (this.cache instanceof LRUCache) {
            return ((LRUCache)this.cache).getEvicted();
        }
        return -1L;
    }

    public long getMisses() {
        if (this.cache instanceof LRUCache) {
            return ((LRUCache)this.cache).getMisses();
        }
        return -1L;
    }

    public long getHits() {
        if (this.cache instanceof LRUCache) {
            return ((LRUCache)this.cache).getHits();
        }
        return -1L;
    }

    public int getMaxCacheSize() {
        if (this.cache instanceof LRUCache) {
            return ((LRUCache)this.cache).getMaxCacheSize();
        }
        return -1;
    }

    static <S extends Service> void stop(S s) {
        try {
            s.stop();
        }
        catch (Exception e) {
            LOG.debug("Error stopping service {}", s, (Object)e);
        }
    }

    private class MultiplePool
    implements Pool<S> {
        private final Endpoint endpoint;
        private final ConcurrentLinkedQueue<S> queue = new ConcurrentLinkedQueue();

        public MultiplePool(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public S acquire() throws Exception {
            Service s = (Service)this.queue.poll();
            if (s == null) {
                s = (Service)ServicePool.this.producer.apply((Object)this.endpoint);
                s.start();
            }
            return s;
        }

        @Override
        public void release(S s) {
            if (this.queue.size() < ServicePool.this.capacity) {
                this.queue.add(s);
            } else {
                ServicePool.stop(s);
            }
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void stop() {
            this.queue.forEach((Consumer)ServicePool::stop);
            this.queue.clear();
        }

        @Override
        public boolean evict(S s) {
            this.queue.remove(s);
            ServicePool.stop(s);
            return this.queue.isEmpty();
        }
    }

    private class SinglePool
    implements Pool<S> {
        private final Endpoint endpoint;
        private volatile S s;

        public SinglePool(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public S acquire() throws Exception {
            if (this.s == null) {
                SinglePool singlePool = this;
                synchronized (singlePool) {
                    if (this.s == null) {
                        this.s = (Service)ServicePool.this.producer.apply((Object)this.endpoint);
                        this.endpoint.getCamelContext().addService(this.s, true, true);
                    }
                }
            }
            return this.s;
        }

        @Override
        public void release(S s) {
        }

        @Override
        public int size() {
            return this.s != null ? 1 : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Object toStop = null;
            SinglePool singlePool = this;
            synchronized (singlePool) {
                toStop = this.s;
                this.s = null;
            }
            this.doStop(toStop);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(S s) {
            SinglePool singlePool = this;
            synchronized (singlePool) {
                if (this.s == s) {
                    this.s = null;
                }
            }
            this.doStop(s);
            return true;
        }

        void doStop(S s) {
            if (s != null) {
                ServicePool.stop(s);
                try {
                    this.endpoint.getCamelContext().removeService(s);
                }
                catch (Exception e) {
                    LOG.debug("Error removing service {}", s, (Object)e);
                }
            }
        }
    }

    static class Key<S> {
        private final S s;

        public Key(S s) {
            this.s = Objects.requireNonNull(s);
        }

        public boolean equals(Object o) {
            return o instanceof Key && ((Key)o).s == this.s;
        }

        public int hashCode() {
            return this.s.hashCode();
        }
    }

    static interface Pool<S> {
        public S acquire() throws Exception;

        public void release(S var1);

        public int size();

        public void stop();

        public boolean evict(S var1);
    }
}

