/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthCheck
implements HealthCheck {
    public static final String CHECK_ID = "check.id";
    public static final String CHECK_GROUP = "check.group";
    public static final String CHECK_ENABLED = "check.enabled";
    public static final String INVOCATION_COUNT = "invocation.count";
    public static final String INVOCATION_TIME = "invocation.time";
    public static final String INVOCATION_ATTEMPT_TIME = "invocation.attempt.time";
    public static final String FAILURE_COUNT = "failure.count";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHealthCheck.class);
    private final Object lock = new Object();
    private final String group;
    private final String id;
    private final ConcurrentMap<String, Object> meta;
    private HealthCheckConfiguration configuration;
    private HealthCheck.Result lastResult;
    private ZonedDateTime lastInvocation;

    protected AbstractHealthCheck(String id) {
        this(null, id, null);
    }

    protected AbstractHealthCheck(String group, String id) {
        this(group, id, null);
    }

    protected AbstractHealthCheck(String group, String id, Map<String, Object> meta) {
        this.group = group;
        this.id = (String)ObjectHelper.notNull((Object)id, (String)"HealthCheck ID");
        this.configuration = new HealthCheckConfiguration();
        this.meta = new ConcurrentHashMap<String, Object>();
        if (meta != null) {
            this.meta.putAll(meta);
        }
        this.meta.put(CHECK_ID, id);
        if (group != null) {
            this.meta.putIfAbsent(CHECK_GROUP, group);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.meta);
    }

    public HealthCheckConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HealthCheckConfiguration configuration) {
        this.configuration = configuration;
    }

    public HealthCheck.Result call() {
        return this.call(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheck.Result call(Map<String, Object> options) {
        Object object = this.lock;
        synchronized (object) {
            Duration elapsed;
            HealthCheckConfiguration conf = this.getConfiguration();
            HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)this);
            ZonedDateTime now = ZonedDateTime.now();
            boolean enabled = (Boolean)ObjectHelper.supplyIfEmpty((Object)conf.isEnabled(), HealthCheckConfiguration::defaultValueEnabled);
            Duration interval = (Duration)ObjectHelper.supplyIfEmpty((Object)conf.getInterval(), HealthCheckConfiguration::defaultValueInterval);
            Integer threshold = (Integer)ObjectHelper.supplyIfEmpty((Object)conf.getFailureThreshold(), HealthCheckConfiguration::defaultValueFailureThreshold);
            int invocationCount = (Integer)this.meta.getOrDefault(INVOCATION_COUNT, 0);
            int failureCount = (Integer)this.meta.getOrDefault(FAILURE_COUNT, 0);
            String invocationTime = now.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
            boolean call = true;
            this.meta.put(INVOCATION_ATTEMPT_TIME, invocationTime);
            if (!enabled) {
                LOGGER.debug("health-check {}/{} won't be invoked as not enabled", (Object)this.getGroup(), (Object)this.getId());
                builder.message("Disabled");
                builder.detail(CHECK_ENABLED, (Object)false);
                return builder.unknown().build();
            }
            if (this.lastResult != null && this.lastInvocation != null && !interval.isZero() && (elapsed = Duration.between(this.lastInvocation, now)).compareTo(interval) < 0) {
                LOGGER.debug("health-check {}/{} won't be invoked as interval ({}) is not yet expired (last-invocation={})", new Object[]{this.getGroup(), this.getId(), elapsed, this.lastInvocation});
                call = false;
            }
            if (call) {
                LOGGER.debug("Invoke health-check {}/{}", (Object)this.getGroup(), (Object)this.getId());
                this.doCall(builder, options);
                ObjectHelper.notNull((Object)builder.state(), (String)"Response State");
                if (builder.state() == HealthCheck.State.DOWN) {
                    if (failureCount++ < threshold) {
                        LOGGER.debug("Health-check {}/{} has status DOWN but failure count ({}) is less than configured threshold ({})", new Object[]{this.getGroup(), this.getId(), failureCount, threshold});
                        builder.up();
                    }
                } else {
                    failureCount = 0;
                }
                this.meta.put(INVOCATION_TIME, invocationTime);
                this.meta.put(FAILURE_COUNT, failureCount);
                this.meta.put(INVOCATION_COUNT, ++invocationCount);
                builder.detail(INVOCATION_TIME, this.meta.get(INVOCATION_TIME));
                builder.detail(INVOCATION_COUNT, this.meta.get(INVOCATION_COUNT));
                builder.detail(FAILURE_COUNT, this.meta.get(FAILURE_COUNT));
                this.lastInvocation = now;
            } else if (this.lastResult != null) {
                this.lastResult.getMessage().ifPresent(arg_0 -> ((HealthCheckResultBuilder)builder).message(arg_0));
                this.lastResult.getError().ifPresent(arg_0 -> ((HealthCheckResultBuilder)builder).error(arg_0));
                builder.state(this.lastResult.getState());
                builder.details(this.lastResult.getDetails());
            }
            this.lastResult = builder.build();
            return this.lastResult;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHealthCheck check = (AbstractHealthCheck)o;
        return this.id != null ? this.id.equals(check.id) : check.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    protected final void addMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    protected abstract void doCall(HealthCheckResultBuilder var1, Map<String, Object> var2);
}

