/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.DefaultRouteError;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.SupervisingRouteController;

class InternalRouteController
implements RouteController {
    private final AbstractCamelContext abstractCamelContext;

    public InternalRouteController(AbstractCamelContext abstractCamelContext) {
        this.abstractCamelContext = abstractCamelContext;
    }

    public LoggingLevel getLoggingLevel() {
        throw new UnsupportedOperationException();
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        throw new UnsupportedOperationException();
    }

    public boolean isSupervising() {
        return false;
    }

    public SupervisingRouteController supervising() {
        throw new UnsupportedOperationException();
    }

    public <T extends RouteController> T adapt(Class<T> type) {
        return (T)((RouteController)type.cast(this));
    }

    public Collection<Route> getControlledRoutes() {
        return this.abstractCamelContext.getRoutes();
    }

    public void startAllRoutes() throws Exception {
        this.abstractCamelContext.startAllRoutes();
    }

    public void stopAllRoutes() throws Exception {
        this.abstractCamelContext.stopAllRoutes();
    }

    public void removeAllRoutes() throws Exception {
        this.abstractCamelContext.removeAllRoutes();
    }

    public void reloadAllRoutes() throws Exception {
        this.abstractCamelContext.setLockModel(true);
        try {
            this.abstractCamelContext.removeAllRoutes();
            this.abstractCamelContext.getEndpointRegistry().clear();
        }
        finally {
            this.abstractCamelContext.setLockModel(false);
        }
        this.abstractCamelContext.removeRouteDefinitionsFromTemplate();
        this.abstractCamelContext.startRouteDefinitions();
    }

    public boolean isReloadingRoutes() {
        return this.abstractCamelContext.isLockModel();
    }

    public boolean isStartingRoutes() {
        return this.abstractCamelContext.isStartingRoutes();
    }

    public boolean hasUnhealthyRoutes() {
        return false;
    }

    public ServiceStatus getRouteStatus(String routeId) {
        return this.abstractCamelContext.getRouteStatus(routeId);
    }

    public void startRoute(String routeId) throws Exception {
        this.abstractCamelContext.startRoute(routeId);
    }

    public void stopRoute(String routeId) throws Exception {
        this.abstractCamelContext.stopRoute(routeId);
    }

    public void stopRoute(String routeId, Throwable cause) throws Exception {
        Route route = this.abstractCamelContext.getRoute(routeId);
        if (route != null) {
            this.abstractCamelContext.stopRoute(routeId);
            route.setLastError((RouteError)new DefaultRouteError(RouteError.Phase.STOP, cause, true));
        }
    }

    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.abstractCamelContext.stopRoute(routeId, timeout, timeUnit);
    }

    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        return this.abstractCamelContext.stopRoute(routeId, timeout, timeUnit, abortAfterTimeout, LoggingLevel.INFO);
    }

    public void suspendRoute(String routeId) throws Exception {
        this.abstractCamelContext.suspendRoute(routeId);
    }

    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.abstractCamelContext.suspendRoute(routeId, timeout, timeUnit);
    }

    public void resumeRoute(String routeId) throws Exception {
        this.abstractCamelContext.resumeRoute(routeId);
    }

    public void setCamelContext(CamelContext camelContext) {
        throw new UnsupportedOperationException();
    }

    public CamelContext getCamelContext() {
        throw new UnsupportedOperationException();
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }
}

