/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.PooledExchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.engine.PrototypeProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.support.DefaultPooledExchange;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledProcessorExchangeFactory
extends PrototypeProcessorExchangeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PooledProcessorExchangeFactory.class);

    public PooledProcessorExchangeFactory() {
    }

    public PooledProcessorExchangeFactory(Processor processor) {
        super(processor);
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public ProcessorExchangeFactory newProcessorExchangeFactory(Processor processor) {
        PooledProcessorExchangeFactory answer = new PooledProcessorExchangeFactory(processor);
        answer.setStatisticsEnabled(this.statisticsEnabled);
        answer.setCapacity(this.capacity);
        answer.setCamelContext(this.camelContext);
        return answer;
    }

    @Override
    public Exchange createCopy(Exchange exchange) {
        Exchange answer = (Exchange)this.pool.poll();
        if (answer == null) {
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
            answer = new DefaultPooledExchange(exchange);
        } else if (this.statisticsEnabled) {
            this.statistics.acquired.increment();
        }
        PooledExchange ee = (PooledExchange)answer;
        ee.reset(System.currentTimeMillis());
        ExchangeHelper.copyResults((Exchange)answer, (Exchange)exchange);
        return answer;
    }

    @Override
    public Exchange createCorrelatedCopy(Exchange exchange, boolean handover) {
        Exchange answer = (Exchange)this.pool.poll();
        if (answer == null) {
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
            answer = new DefaultPooledExchange(exchange);
            answer.getExchangeExtension().setUnitOfWork(null);
        } else if (this.statisticsEnabled) {
            this.statistics.acquired.increment();
        }
        PooledExchange ee = (PooledExchange)answer;
        ee.reset(System.currentTimeMillis());
        ExchangeHelper.copyResults((Exchange)answer, (Exchange)exchange);
        answer.getIn().setMessageId(null);
        if (handover) {
            answer.getExchangeExtension().handoverCompletions(exchange);
        }
        answer.setProperty(ExchangePropertyKey.CORRELATION_ID, (Object)exchange.getExchangeId());
        return answer;
    }

    @Override
    public Exchange create(Endpoint fromEndpoint, ExchangePattern exchangePattern) {
        Exchange answer = (Exchange)this.pool.poll();
        if (answer == null) {
            answer = new DefaultPooledExchange(fromEndpoint, exchangePattern);
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
        } else if (this.statisticsEnabled) {
            this.statistics.acquired.increment();
        }
        PooledExchange ee = (PooledExchange)answer;
        ee.reset(System.currentTimeMillis());
        return answer;
    }

    @Override
    public boolean release(Exchange exchange) {
        try {
            PooledExchange ee = (PooledExchange)exchange;
            ee.done();
            boolean inserted = this.pool.offer(exchange);
            if (this.statisticsEnabled) {
                if (inserted) {
                    this.statistics.released.increment();
                } else {
                    this.statistics.discarded.increment();
                }
            }
            return inserted;
        }
        catch (Exception e) {
            if (this.statisticsEnabled) {
                this.statistics.discarded.increment();
            }
            LOG.debug("Error resetting exchange: {}. This exchange is discarded.", (Object)exchange);
            return false;
        }
    }
}

