/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TimerListener;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;

public final class DefaultPeriodTaskScheduler
extends TimerListenerManager
implements PeriodTaskScheduler {
    public void schedulePeriodTask(Runnable task, long period) {
        this.addTimerListener(new TaskWrapper(task, period));
    }

    public <T> T getTaskByType(Class<T> type) {
        Iterator iterator = this.getListeners().iterator();
        while (iterator.hasNext()) {
            TimerListener listener;
            Object task = listener = (TimerListener)iterator.next();
            if (listener instanceof TaskWrapper) {
                task = ((TaskWrapper)listener).getTask();
            }
            if (!type.isInstance(task)) continue;
            return type.cast(task);
        }
        return null;
    }

    public void addTimerListener(TimerListener listener) {
        if (!(listener instanceof TaskWrapper)) {
            throw new IllegalArgumentException("Use the addPeriodTask method");
        }
        super.addTimerListener(listener);
    }

    private final class TaskWrapper
    extends ServiceSupport
    implements TimerListener {
        private final StopWatch watch = new StopWatch();
        private final Runnable task;
        private final long period;

        public TaskWrapper(Runnable task, long period) {
            this.task = task;
            this.period = period;
        }

        public Runnable getTask() {
            return this.task;
        }

        public void onTimer() {
            if (this.watch.taken() > this.period) {
                this.watch.restart();
                this.task.run();
            }
        }

        protected void doBuild() throws Exception {
            CamelContextAware.trySetCamelContext((Object)this.task, (CamelContext)DefaultPeriodTaskScheduler.this.getCamelContext());
            ServiceHelper.buildService((Object)this.task);
        }

        protected void doInit() throws Exception {
            ServiceHelper.initService((Object)this.task);
        }

        protected void doStart() throws Exception {
            ServiceHelper.startService((Object)this.task);
        }

        protected void doStop() throws Exception {
            ServiceHelper.stopService((Object)this.task);
        }

        protected void doShutdown() throws Exception {
            ServiceHelper.stopAndShutdownService((Object)this.task);
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

