/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2.client;

import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.client.AWS2EC2InternalClient;
import org.apache.camel.component.aws2.ec2.client.impl.AWS2EC2ClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.ec2.client.impl.AWS2EC2ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.ec2.client.impl.AWS2EC2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.ec2.client.impl.AWS2EC2ClientStandardImpl;

public final class AWS2EC2ClientFactory {
    private AWS2EC2ClientFactory() {
    }

    public static AWS2EC2InternalClient getEc2Client(AWS2EC2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new AWS2EC2ClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new AWS2EC2ClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new AWS2EC2ClientSessionTokenImpl(configuration);
        }
        return new AWS2EC2ClientStandardImpl(configuration);
    }
}

