/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ses;

import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.common.AwsExchangeUtil;
import org.apache.camel.component.aws.ses.SesConfiguration;
import org.apache.camel.component.aws.ses.SesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;

public class SesProducer
extends DefaultProducer {
    private transient String sesProducerToString;

    public SesProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        if (!(exchange.getIn().getBody() instanceof javax.mail.Message)) {
            SendEmailRequest request = this.createMailRequest(exchange);
            this.log.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
            SendEmailResult result = this.getEndpoint().getSESClient().sendEmail(request);
            this.log.trace("Received result [{}]", (Object)result);
            Message message = AwsExchangeUtil.getMessageForResponse(exchange);
            message.setHeader("CamelAwsSesMessageId", (Object)result.getMessageId());
        } else {
            SendRawEmailRequest request = this.createRawMailRequest(exchange);
            this.log.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
            SendRawEmailResult result = this.getEndpoint().getSESClient().sendRawEmail(request);
            this.log.trace("Received result [{}]", (Object)result);
            Message message = AwsExchangeUtil.getMessageForResponse(exchange);
            message.setHeader("CamelAwsSesMessageId", (Object)result.getMessageId());
        }
    }

    private SendEmailRequest createMailRequest(Exchange exchange) {
        SendEmailRequest request = new SendEmailRequest();
        request.setSource(this.determineFrom(exchange));
        request.setDestination(this.determineTo(exchange));
        request.setReturnPath(this.determineReturnPath(exchange));
        request.setReplyToAddresses(this.determineReplyToAddresses(exchange));
        request.setMessage(this.createMessage(exchange));
        return request;
    }

    private SendRawEmailRequest createRawMailRequest(Exchange exchange) throws Exception {
        SendRawEmailRequest request = new SendRawEmailRequest();
        request.setSource(this.determineFrom(exchange));
        request.setDestinations((Collection)this.determineRawTo(exchange));
        request.setRawMessage(this.createRawMessage(exchange));
        return request;
    }

    private com.amazonaws.services.simpleemail.model.Message createMessage(Exchange exchange) {
        com.amazonaws.services.simpleemail.model.Message message = new com.amazonaws.services.simpleemail.model.Message();
        Boolean isHtmlEmail = (Boolean)exchange.getIn().getHeader("CamelAwsSesHtmlEmail", (Object)false, Boolean.class);
        String content = (String)exchange.getIn().getBody(String.class);
        if (isHtmlEmail.booleanValue()) {
            message.setBody(new Body().withHtml(new Content().withData(content)));
        } else {
            message.setBody(new Body().withText(new Content().withData(content)));
        }
        message.setSubject(new Content(this.determineSubject(exchange)));
        return message;
    }

    private RawMessage createRawMessage(Exchange exchange) throws Exception {
        RawMessage message = new RawMessage();
        javax.mail.Message content = (javax.mail.Message)exchange.getIn().getBody(javax.mail.Message.class);
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            content.writeTo((OutputStream)byteOutput);
        }
        catch (Exception e) {
            this.log.error("Cannot write to byte Array");
            throw e;
        }
        byte[] messageByteArray = byteOutput.toByteArray();
        message.setData(ByteBuffer.wrap(messageByteArray));
        return message;
    }

    private Collection<String> determineReplyToAddresses(Exchange exchange) {
        List<String> replyToAddresses = (List<String>)exchange.getIn().getHeader("CamelAwsSesReplyToAddresses", List.class);
        if (replyToAddresses == null) {
            replyToAddresses = this.getConfiguration().getReplyToAddresses();
        }
        return replyToAddresses;
    }

    private String determineReturnPath(Exchange exchange) {
        String returnPath = (String)exchange.getIn().getHeader("CamelAwsSesReturnPath", String.class);
        if (returnPath == null) {
            returnPath = this.getConfiguration().getReturnPath();
        }
        return returnPath;
    }

    private Destination determineTo(Exchange exchange) {
        List<String> to = (List<String>)exchange.getIn().getHeader("CamelAwsSesTo", List.class);
        if (to == null) {
            to = this.getConfiguration().getTo();
        }
        return new Destination(to);
    }

    private List determineRawTo(Exchange exchange) {
        List<String> to = (List<String>)exchange.getIn().getHeader("CamelAwsSesTo", List.class);
        if (to == null) {
            to = this.getConfiguration().getTo();
        }
        return to;
    }

    private String determineFrom(Exchange exchange) {
        String from = (String)exchange.getIn().getHeader("CamelAwsSesFrom", String.class);
        if (from == null) {
            from = this.getConfiguration().getFrom();
        }
        return from;
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSesSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    protected SesConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.sesProducerToString == null) {
            this.sesProducerToString = "SesProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.sesProducerToString;
    }

    public SesEndpoint getEndpoint() {
        return (SesEndpoint)super.getEndpoint();
    }
}

