/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;

public abstract class FeedEntryPollingConsumer<E>
extends FeedPollingConsumer {
    protected int entryIndex;
    protected List<E> list;
    protected boolean throttleEntries;
    protected Object feed;

    protected FeedEntryPollingConsumer(FeedEndpoint endpoint, Processor processor, boolean throttleEntries) {
        super(endpoint, processor);
        this.throttleEntries = throttleEntries;
    }

    @Override
    public int poll() throws Exception {
        if (this.feed == null) {
            this.feed = this.createFeed();
            this.populateList(this.feed);
        }
        int polledMessages = 0;
        while (this.hasNextEntry()) {
            E entry = this.list.get(this.entryIndex--);
            ++polledMessages;
            Exchange exchange = this.endpoint.createExchange(this.feed, entry);
            this.getProcessor().process(exchange);
            if (!this.throttleEntries) continue;
            return polledMessages;
        }
        this.feed = null;
        this.resetList();
        return polledMessages;
    }

    protected abstract void resetList();

    protected abstract void populateList(Object var1) throws Exception;

    private boolean hasNextEntry() {
        return this.entryIndex >= 0;
    }
}

