/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;

public abstract class FeedEntryPollingConsumer
extends FeedPollingConsumer {
    protected int entryIndex;
    protected EntryFilter entryFilter;
    protected List list;

    public FeedEntryPollingConsumer(FeedEndpoint endpoint, Processor processor, boolean filter, Date lastUpdate) {
        super(endpoint, processor);
        if (filter) {
            this.entryFilter = this.createEntryFilter(lastUpdate);
        }
    }

    public void poll() throws Exception {
        Object feed = this.createFeed();
        this.populateList(feed);
        while (this.hasNextEntry()) {
            Object entry = this.list.get(this.entryIndex--);
            boolean valid = true;
            if (this.entryFilter != null) {
                valid = this.entryFilter.isValidEntry(this.endpoint, feed, entry);
            }
            if (!valid) continue;
            Exchange exchange = this.endpoint.createExchange(feed, entry);
            this.getProcessor().process(exchange);
            return;
        }
        this.resetList();
    }

    protected abstract EntryFilter createEntryFilter(Date var1);

    protected abstract void resetList();

    protected abstract void populateList(Object var1) throws Exception;

    private boolean hasNextEntry() {
        return this.entryIndex >= 0;
    }
}

