/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.MultipartReportEntity;
import org.apache.camel.component.as2.api.entity.TextPlainEntity;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;

public class DispositionNotificationMultipartReportEntity
extends MultipartReportEntity {
    protected DispositionNotificationMultipartReportEntity(String boundary, String contentTransferEncoding, boolean isMainBody) {
        super(ContentType.parse((CharSequence)("multipart/report;report-type=disposition-notification; boundary=\"" + boundary + "\"")), contentTransferEncoding, isMainBody, boundary);
    }

    public DispositionNotificationMultipartReportEntity(ClassicHttpRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, String charset, String boundary, boolean isMainBody, PrivateKey decryptingPrivateKey, String mdnMessage, Certificate[] validateSigningCertificateChain) throws HttpException {
        super(ContentType.parse((CharSequence)("multipart/report;report-type=disposition-notification; boundary=\"" + boundary + "\"")), null, isMainBody, boundary);
        ObjectHelper.notNull((Object)((Object)dispositionMode), (String)"dispositionMode");
        ObjectHelper.notNull((Object)((Object)dispositionType), (String)"dispositionType");
        ObjectHelper.notNull((Object)mdnMessage, (String)"mdnMessageTemplate");
        this.addPart(this.buildPlainTextReport(mdnMessage));
        this.addPart(new AS2MessageDispositionNotificationEntity(request, response, dispositionMode, dispositionType, dispositionModifier, failureFields, errorFields, warningFields, extensionFields, charset, false, decryptingPrivateKey, validateSigningCertificateChain));
    }

    public String getMainMessageContentType() {
        return "multipart/report; report-type=disposition-notification; boundary=\"" + this.boundary + "\"";
    }

    protected TextPlainEntity buildPlainTextReport(String mdnMessage) {
        return new TextPlainEntity(mdnMessage, StandardCharsets.US_ASCII.name(), "7bit", false);
    }
}

