/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.time.Duration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.TimeUtils;

public class HealthCheckConfiguration
implements Cloneable {
    private String parent;
    private boolean enabled = true;
    @Deprecated
    private long interval;
    @Deprecated
    private int failureThreshold;
    @Deprecated
    private int successThreshold;

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated
    public long getInterval() {
        return this.interval;
    }

    @Deprecated
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Deprecated
    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    @Deprecated
    public void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    @Deprecated
    public int getSuccessThreshold() {
        return this.successThreshold;
    }

    @Deprecated
    public void setSuccessThreshold(int successThreshold) {
        this.successThreshold = successThreshold;
    }

    public HealthCheckConfiguration copy() {
        try {
            return (HealthCheckConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements org.apache.camel.Builder<HealthCheckConfiguration> {
        private String parent;
        private Boolean enabled;
        private Long interval;
        private Integer failureThreshold;
        private Integer successThreshold;

        private Builder() {
        }

        public Builder complete(HealthCheckConfiguration template) {
            if (template != null) {
                if (this.parent == null) {
                    this.parent = template.parent;
                }
                if (this.enabled == null) {
                    this.enabled = template.enabled;
                }
                if (this.interval == null) {
                    this.interval = template.interval;
                }
                if (this.failureThreshold == null) {
                    this.failureThreshold = template.failureThreshold;
                }
                if (this.successThreshold == null) {
                    this.successThreshold = template.successThreshold;
                }
            }
            return this;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Deprecated
        public Builder interval(Duration interval) {
            this.interval = interval.toMillis();
            return this;
        }

        @Deprecated
        public Builder interval(String interval) {
            return ObjectHelper.isNotEmpty((Object)interval) ? this.interval(TimeUtils.toMilliSeconds((String)interval)) : this;
        }

        @Deprecated
        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        @Deprecated
        public Builder failureThreshold(int failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        @Deprecated
        public Builder successThreshold(int successThreshold) {
            this.successThreshold = successThreshold;
            return this;
        }

        @Override
        public HealthCheckConfiguration build() {
            HealthCheckConfiguration conf = new HealthCheckConfiguration();
            if (this.parent != null) {
                conf.setParent(this.parent);
            }
            if (this.enabled != null) {
                conf.setEnabled(this.enabled);
            }
            if (this.interval != null) {
                conf.setInterval(this.interval);
            }
            if (this.failureThreshold != null) {
                conf.setFailureThreshold(this.failureThreshold);
            }
            if (this.successThreshold != null) {
                conf.setSuccessThreshold(this.successThreshold);
            }
            return conf;
        }
    }
}

