/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.RuntimeCamelException;

public class PropertyBindingException
extends RuntimeCamelException {
    private final Object target;
    private final String propertyName;
    private final Object value;
    private final String optionPrefix;
    private final String optionKey;

    public PropertyBindingException(Object target, String propertyName, Object value) {
        this.target = target;
        this.propertyName = propertyName;
        this.value = value;
        this.optionPrefix = null;
        this.optionKey = null;
    }

    public PropertyBindingException(Object target, String propertyName, Object value, Throwable e) {
        this.initCause(e);
        this.target = target;
        this.propertyName = propertyName;
        this.value = value;
        this.optionPrefix = null;
        this.optionKey = null;
    }

    public PropertyBindingException(Object target, Throwable e) {
        this.initCause(e);
        this.target = target;
        this.propertyName = null;
        this.value = null;
        this.optionPrefix = null;
        this.optionKey = null;
    }

    public PropertyBindingException(Object target, String propertyName, Object value, String optionPrefix, String optionKey, Throwable e) {
        this.initCause(e);
        this.target = target;
        this.propertyName = propertyName;
        this.value = value;
        this.optionPrefix = optionPrefix;
        this.optionKey = optionKey;
    }

    @Override
    public String getMessage() {
        String stringValue = this.value != null ? this.value.toString() : "";
        String key = this.propertyName;
        if (this.optionPrefix != null && this.optionKey != null) {
            key = this.optionPrefix + "." + this.optionKey;
        }
        if (key != null) {
            return "Error binding property (" + key + "=" + stringValue + ") with name: " + this.propertyName + " on bean: " + this.target + " with value: " + stringValue;
        }
        return "Error binding properties on bean: " + this.target;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getOptionPrefix() {
        return this.optionPrefix;
    }

    public String getOptionKey() {
        return this.optionKey;
    }
}

