/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"org.apache.camel.Converter"})
public class TypeConverterProcessor
extends AbstractCamelAnnotationProcessor {
    boolean acceptClass(Element element) {
        return !TypeConverterProcessor.isLoaderEnabled(element);
    }

    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        TypeElement converterAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.Converter");
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(converterAnnotationType);
        TreeMap<String, Element> converterClasses = new TreeMap<String, Element>();
        for (Element element : elements) {
            TypeElement te;
            if (!(element instanceof TypeElement) || (te = (TypeElement)element).getNestingKind().isNested() || !this.acceptClass(te)) continue;
            String javaTypeName = Strings.canonicalClassName(te.getQualifiedName().toString());
            converterClasses.put(javaTypeName, element);
        }
        if (!(converterClasses.isEmpty() || converterClasses.containsKey("org.apache.camel.converter.IOConverter") || converterClasses.containsKey("org.apache.camel.converter.jaxp.DomConverter") || converterClasses.containsKey("org.apache.camel.converter.jaxp.XmlConverter") || converterClasses.containsKey("org.apache.camel.util.xml.StreamSourceConverter") || converterClasses.containsKey("org.apache.camel.converter.stream.StreamCacheConverter"))) {
            Filer filer = this.processingEnv.getFiler();
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org/apache/camel/TypeConverter", converterClasses.values().toArray(new Element[0]));
            try (Writer w = fileObject.openWriter();){
                w.append("# Generated by camel annotation processor\n");
                for (String s : converterClasses.keySet()) {
                    w.append(s).append("\n");
                }
            }
        }
    }

    private static boolean isLoaderEnabled(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"generateLoader".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }
}

