/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;
import org.apache.camel.tools.apt.ComponentPropertyConfigurerGenerator;
import org.apache.camel.tools.apt.DocumentationHelper;
import org.apache.camel.tools.apt.EndpointPropertyConfigurerGenerator;
import org.apache.camel.tools.apt.helper.EndpointHelper;
import org.apache.camel.tools.apt.helper.JsonSchemaHelper;
import org.apache.camel.tools.apt.helper.Strings;
import org.apache.camel.tools.apt.model.ComponentModel;
import org.apache.camel.tools.apt.model.ComponentOption;
import org.apache.camel.tools.apt.model.EndpointOption;
import org.apache.camel.tools.apt.model.EndpointPath;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@SupportedAnnotationTypes(value={"org.apache.camel.spi.*"})
public class EndpointAnnotationProcessor
extends AbstractCamelAnnotationProcessor {
    private static final String HEADER_FILTER_STRATEGY_JAVADOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";

    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(UriEndpoint.class);
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processEndpointClass(roundEnv, (TypeElement)element);
        }
    }

    private void processEndpointClass(RoundEnvironment roundEnv, TypeElement classElement) {
        UriEndpoint uriEndpoint = classElement.getAnnotation(UriEndpoint.class);
        if (uriEndpoint != null) {
            String scheme = uriEndpoint.scheme();
            String extendsScheme = uriEndpoint.extendsScheme();
            String title = uriEndpoint.title();
            String label = uriEndpoint.label();
            this.validateSchemaName(scheme, classElement);
            if (!Strings.isNullOrEmpty(scheme)) {
                String[] schemes = scheme.split(",");
                String[] titles = title.split(",");
                String[] extendsSchemes = extendsScheme.split(",");
                for (int i = 0; i < schemes.length; ++i) {
                    String aTitle;
                    String alias = schemes[i];
                    String extendsAlias = i < extendsSchemes.length ? extendsSchemes[i] : extendsSchemes[0];
                    String string = aTitle = i < titles.length ? titles[i] : titles[0];
                    if (EndpointAnnotationProcessor.secureAlias(schemes[0], alias)) {
                        aTitle = aTitle + " (Secure)";
                    }
                    String aliasTitle = aTitle;
                    String name = Strings.canonicalClassName(classElement.getQualifiedName().toString());
                    String packageName = name.substring(0, name.lastIndexOf("."));
                    String fileName = alias + ".json";
                    AnnotationProcessorHelper.processFile(this.processingEnv, packageName, fileName, writer -> this.writeJSonSchemeAndPropertyConfigurer((PrintWriter)writer, roundEnv, classElement, uriEndpoint, aliasTitle, alias, extendsAlias, label, schemes));
                }
            }
        }
    }

    private void validateSchemaName(String schemaName, TypeElement classElement) {
        if (!schemaName.equals(schemaName.toLowerCase())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Mixed case schema name in '%s' with value '%s' has been deprecated. Please use lowercase only!", classElement.getQualifiedName(), schemaName));
        }
    }

    protected void writeJSonSchemeAndPropertyConfigurer(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, UriEndpoint uriEndpoint, String title, String scheme, String extendsScheme, String label, String[] schemes) {
        TypeElement componentClassElement;
        UriEndpoint parentUriEndpoint;
        String superClassName;
        String[] baseTypeElement;
        ComponentModel componentModel = this.findComponentProperties(roundEnv, uriEndpoint, classElement, title, scheme, extendsScheme, label);
        LinkedHashSet<EndpointPath> endpointPaths = new LinkedHashSet<EndpointPath>();
        LinkedHashSet<EndpointOption> endpointOptions = new LinkedHashSet<EndpointOption>();
        LinkedHashSet<ComponentOption> componentOptions = new LinkedHashSet<ComponentOption>();
        JsonObject parentData = null;
        TypeMirror superclass = classElement.getSuperclass();
        if (superclass != null && (baseTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, superClassName = Strings.canonicalClassName(superclass.toString()))) != null && !roundEnv.getRootElements().contains(baseTypeElement) && (parentUriEndpoint = baseTypeElement.getAnnotation(UriEndpoint.class)) != null) {
            String parentScheme = parentUriEndpoint.scheme().split(",")[0];
            String packageName = superClassName.substring(0, superClassName.lastIndexOf("."));
            String fileName = parentScheme + ".json";
            try {
                FileObject res = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_PATH, packageName, fileName);
                String json = res.getCharContent(false).toString();
                parentData = Jsoner.deserialize((String)json, (JsonObject)null);
            }
            catch (Exception e) {
                throw new RuntimeException("Error: " + e.toString(), e);
            }
        }
        if (parentData != null && parentData.get((Object)"properties") != null) {
            Map map = (Map)parentData.get((Object)"properties");
            for (String exclude : uriEndpoint.excludeProperties().split(",")) {
                map.remove(exclude);
            }
        }
        if ((componentClassElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, componentModel.getJavaType())) != null) {
            this.findComponentClassProperties(writer, roundEnv, componentModel, (Set<ComponentOption>)componentOptions, componentClassElement, "", (Map<String, Object>)parentData, null, null);
        }
        if (!"@@@JAVATYPE@@@".equals(componentModel.getJavaType())) {
            this.generateComponentConfigurer(roundEnv, uriEndpoint, scheme, schemes, componentModel, componentOptions);
        }
        this.findClassProperties(writer, roundEnv, componentModel, (Set<EndpointPath>)endpointPaths, (Set<EndpointOption>)endpointOptions, classElement, "", uriEndpoint.excludeProperties(), (Map<String, Object>)parentData, null, null);
        String json = this.createParameterJsonSchema(componentModel, (Set<ComponentOption>)componentOptions, (Set<EndpointPath>)endpointPaths, (Set<EndpointOption>)endpointOptions, schemes, (Map<String, Object>)parentData);
        writer.println(json);
        this.generateEndpointConfigurer(roundEnv, classElement, uriEndpoint, scheme, schemes, componentModel, endpointOptions);
    }

    private void generateComponentConfigurer(RoundEnvironment roundEnv, UriEndpoint uriEndpoint, String scheme, String[] schemes, ComponentModel componentModel, Set<ComponentOption> componentOptions) {
        TypeElement parent = "activemq".equals(scheme) || "amqp".equals(scheme) ? AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, "org.apache.camel.component.jms.JmsComponentConfigurer") : AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, "org.apache.camel.spi.GeneratedPropertyConfigurer");
        String fqComponentClassName = componentModel.getJavaType();
        String componentClassName = fqComponentClassName.substring(fqComponentClassName.lastIndexOf(46) + 1);
        String className = componentClassName + "Configurer";
        String packageName = fqComponentClassName.substring(0, fqComponentClassName.lastIndexOf(46));
        String fqClassName = packageName + "." + className;
        if ("activemq".equals(scheme) || "amqp".equals(scheme)) {
            ComponentPropertyConfigurerGenerator.generateExtendConfigurer(this.processingEnv, parent, packageName, className, fqClassName);
            ComponentPropertyConfigurerGenerator.generateMetaInfConfigurer(this.processingEnv, componentModel.getScheme() + "-component", fqClassName);
        } else if (uriEndpoint.generateConfigurer() && !componentOptions.isEmpty() && (schemes == null || schemes[0].equals(scheme))) {
            ComponentPropertyConfigurerGenerator.generatePropertyConfigurer(this.processingEnv, parent, packageName, className, fqClassName, componentClassName, componentOptions);
            ComponentPropertyConfigurerGenerator.generateMetaInfConfigurer(this.processingEnv, componentModel.getScheme() + "-component", fqClassName);
        }
    }

    private void generateEndpointConfigurer(RoundEnvironment roundEnv, TypeElement classElement, UriEndpoint uriEndpoint, String scheme, String[] schemes, ComponentModel componentModel, Set<EndpointOption> endpointOptions) {
        TypeElement parent = "activemq".equals(scheme) || "amqp".equals(scheme) ? AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, "org.apache.camel.component.jms.JmsEndpointConfigurer") : AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, "org.apache.camel.spi.GeneratedPropertyConfigurer");
        String fqEndpointClassName = classElement.getQualifiedName().toString();
        String packageName = fqEndpointClassName.substring(0, fqEndpointClassName.lastIndexOf(46));
        String endpointClassName = classElement.getSimpleName().toString();
        String className = endpointClassName + "Configurer";
        String fqClassName = packageName + "." + className;
        if ("activemq".equals(scheme) || "amqp".equals(scheme)) {
            EndpointPropertyConfigurerGenerator.generateExtendConfigurer(this.processingEnv, parent, packageName, className, fqClassName);
            EndpointPropertyConfigurerGenerator.generateMetaInfConfigurer(this.processingEnv, componentModel.getScheme() + "-endpoint", fqClassName);
        } else if (uriEndpoint.generateConfigurer() && !endpointOptions.isEmpty() && (schemes == null || schemes[0].equals(scheme))) {
            EndpointPropertyConfigurerGenerator.generatePropertyConfigurer(this.processingEnv, parent, packageName, className, fqClassName, endpointClassName, endpointOptions);
            EndpointPropertyConfigurerGenerator.generateMetaInfConfigurer(this.processingEnv, componentModel.getScheme() + "-endpoint", fqClassName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String createParameterJsonSchema(ComponentModel componentModel, Set<ComponentOption> componentOptions, Set<EndpointPath> endpointPaths, Set<EndpointOption> endpointOptions, String[] schemes, Map<String, Object> parentData) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"component\": {");
        buffer.append("\n    \"kind\": \"").append("component").append("\",");
        buffer.append("\n    \"scheme\": \"").append(componentModel.getScheme()).append("\",");
        if (!Strings.isNullOrEmpty(componentModel.getExtendsScheme())) {
            buffer.append("\n    \"extendsScheme\": \"").append(componentModel.getExtendsScheme()).append("\",");
        }
        if (schemes != null && schemes.length > 1) {
            buffer.append("\n    \"alternativeSchemes\": \"").append(String.join((CharSequence)",", schemes)).append("\",");
        }
        buffer.append("\n    \"syntax\": \"").append(componentModel.getSyntax()).append("\",");
        if (componentModel.getAlternativeSyntax() != null) {
            buffer.append("\n    \"alternativeSyntax\": \"").append(componentModel.getAlternativeSyntax()).append("\",");
        }
        buffer.append("\n    \"title\": \"").append(componentModel.getTitle()).append("\",");
        buffer.append("\n    \"description\": \"").append(componentModel.getDescription()).append("\",");
        buffer.append("\n    \"label\": \"").append(Strings.getOrElse(componentModel.getLabel(), "")).append("\",");
        buffer.append("\n    \"deprecated\": ").append(componentModel.isDeprecated()).append(",");
        buffer.append("\n    \"deprecationNote\": \"").append(Strings.getOrElse(componentModel.getDeprecationNote(), "")).append("\",");
        buffer.append("\n    \"async\": ").append(componentModel.isAsync()).append(",");
        buffer.append("\n    \"consumerOnly\": ").append(componentModel.isConsumerOnly()).append(",");
        buffer.append("\n    \"producerOnly\": ").append(componentModel.isProducerOnly()).append(",");
        buffer.append("\n    \"lenientProperties\": ").append(componentModel.isLenientProperties()).append(",");
        buffer.append("\n    \"javaType\": \"").append(componentModel.getJavaType()).append("\",");
        if (componentModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(componentModel.getFirstVersion()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(componentModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(componentModel.getArtifactId()).append("\",");
        if (componentModel.getVerifiers() != null) {
            buffer.append("\n    \"verifiers\": \"").append(componentModel.getVerifiers()).append("\",");
        }
        buffer.append("\n    \"version\": \"").append(componentModel.getVersionId()).append("\"");
        buffer.append("\n  },");
        Map parentComponentProperties = parentData != null && parentData.get("componentProperties") != null ? (Map)parentData.get("componentProperties") : new HashMap();
        buffer.append("\n  \"componentProperties\": {");
        boolean first = true;
        for (ComponentOption componentOption : componentOptions) {
            void var14_17;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            Object doc = componentOption.getDocumentationWithNotes();
            if (Strings.isNullOrEmpty((String)doc)) {
                doc = DocumentationHelper.findComponentJavaDoc(componentModel.getScheme(), componentModel.getExtendsScheme(), componentOption.getName());
            }
            doc = JsonSchemaHelper.sanitizeDescription((String)doc, false);
            Boolean required = componentOption.isRequired();
            String string = componentOption.getDefaultValue();
            if (Strings.isNullOrEmpty(string) && "boolean".equals(componentOption.getType())) {
                String string2 = "false";
            }
            String optionalPrefix = "";
            String prefix = "";
            boolean multiValue = false;
            boolean asPredicate = false;
            buffer.append(JsonSchemaHelper.toJson(componentOption.getName(), componentOption.getDisplayName(), "property", required, componentOption.getType(), (String)var14_17, (String)doc, componentOption.isDeprecated(), componentOption.getDeprecationNote(), componentOption.isSecret(), componentOption.getGroup(), componentOption.getLabel(), componentOption.isEnumType(), componentOption.getEnums(), false, null, asPredicate, optionalPrefix, prefix, multiValue, componentOption.getConfigurationClass(), componentOption.getConfigurationField()));
            parentComponentProperties.remove(componentOption.getName());
        }
        for (Map.Entry entry : parentComponentProperties.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            buffer.append(Strings.doubleQuote((String)entry.getKey()));
            buffer.append(": ");
            buffer.append(Jsoner.serialize(entry.getValue()));
        }
        buffer.append("\n  },");
        Map parentProperties = parentData != null && parentData.get("properties") != null ? (Map)parentData.get("properties") : new HashMap();
        buffer.append("\n  \"properties\": {");
        first = true;
        ArrayList<EndpointPath> arrayList = new ArrayList<EndpointPath>();
        arrayList.addAll(endpointPaths);
        Collections.sort(arrayList, EndpointHelper.createPathComparator(componentModel.getSyntax()));
        for (EndpointPath entry : arrayList) {
            String string = entry.getLabel();
            if (string != null && (string.contains("consumer") && componentModel.isProducerOnly() || string.contains("producer") && componentModel.isConsumerOnly())) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentation();
            if (Strings.isNullOrEmpty(doc)) {
                doc = DocumentationHelper.findEndpointJavaDoc(componentModel.getScheme(), componentModel.getExtendsScheme(), entry.getName());
            }
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            boolean required = entry.isRequired();
            String defaultValue = entry.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(entry.getType())) {
                defaultValue = "false";
            }
            String optionalPrefix = "";
            String prefix = "";
            boolean multiValue = false;
            boolean asPredicate = false;
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getDisplayName(), "path", required, entry.getType(), defaultValue, doc, entry.isDeprecated(), entry.getDeprecationNote(), entry.isSecret(), entry.getGroup(), entry.getLabel(), entry.isEnumType(), entry.getEnums(), false, null, asPredicate, optionalPrefix, prefix, multiValue, null, null));
            parentProperties.remove(entry.getName());
        }
        ArrayList<EndpointOption> options = new ArrayList<EndpointOption>();
        options.addAll(endpointOptions);
        Collections.sort(options, EndpointHelper.createGroupAndLabelComparator());
        for (EndpointOption endpointOption : options) {
            String label = endpointOption.getLabel();
            if (label != null && (label.contains("consumer") && componentModel.isProducerOnly() || label.contains("producer") && componentModel.isConsumerOnly())) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = endpointOption.getDocumentationWithNotes();
            if (Strings.isNullOrEmpty(doc)) {
                doc = DocumentationHelper.findEndpointJavaDoc(componentModel.getScheme(), componentModel.getExtendsScheme(), endpointOption.getName());
            }
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            Boolean required = endpointOption.isRequired();
            String defaultValue = endpointOption.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(endpointOption.getType())) {
                defaultValue = "false";
            }
            String optionalPrefix = endpointOption.getOptionalPrefix();
            String prefix = endpointOption.getPrefix();
            boolean multiValue = endpointOption.isMultiValue();
            boolean asPredicate = false;
            buffer.append(JsonSchemaHelper.toJson(endpointOption.getName(), endpointOption.getDisplayName(), "parameter", required, endpointOption.getType(), defaultValue, doc, endpointOption.isDeprecated(), endpointOption.getDeprecationNote(), endpointOption.isSecret(), endpointOption.getGroup(), endpointOption.getLabel(), endpointOption.isEnumType(), endpointOption.getEnums(), false, null, asPredicate, optionalPrefix, prefix, multiValue, endpointOption.getConfigurationClass(), endpointOption.getConfigurationField()));
            parentProperties.remove(endpointOption.getName());
        }
        for (Map.Entry entry : parentProperties.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            buffer.append(Strings.doubleQuote((String)entry.getKey()));
            buffer.append(": ");
            buffer.append(Jsoner.serialize(entry.getValue()));
        }
        buffer.append("\n  }");
        buffer.append("\n}\n");
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected ComponentModel findComponentProperties(RoundEnvironment roundEnv, UriEndpoint uriEndpoint, TypeElement endpointClassElement, String title, String scheme, String extendsScheme, String label) {
        String doc;
        void var13_17;
        Set<? extends Element> elements;
        ComponentModel model = new ComponentModel(scheme);
        String syntax = scheme + ":" + Strings.after(uriEndpoint.syntax(), ":");
        if (!Strings.isNullOrEmpty(uriEndpoint.alternativeSyntax())) {
            String alternativeSyntax = scheme + ":" + Strings.after(uriEndpoint.alternativeSyntax(), ":");
            model.setAlternativeSyntax(alternativeSyntax);
        }
        model.setExtendsScheme(extendsScheme);
        model.setSyntax(syntax);
        model.setTitle(title);
        model.setLabel(label);
        model.setConsumerOnly(uriEndpoint.consumerOnly());
        model.setProducerOnly(uriEndpoint.producerOnly());
        model.setLenientProperties(uriEndpoint.lenientProperties());
        model.setAsync(AnnotationProcessorHelper.implementsInterface(this.processingEnv, roundEnv, endpointClassElement, "org.apache.camel.AsyncEndpoint"));
        String firstVersion = uriEndpoint.firstVersion();
        if (Strings.isNullOrEmpty(firstVersion) && endpointClassElement.getAnnotation(Metadata.class) != null) {
            firstVersion = endpointClassElement.getAnnotation(Metadata.class).firstVersion();
        }
        if (!Strings.isNullOrEmpty(firstVersion)) {
            model.setFirstVersion(firstVersion);
        }
        if ((elements = roundEnv.getElementsAnnotatedWith(Component.class)) != null) {
            for (Element element : elements) {
                Component comp = element.getAnnotation(Component.class);
                String[] schemes = comp.value().split(",");
                if (!Arrays.asList(schemes).contains(scheme) || element.getKind() != ElementKind.CLASS) continue;
                TypeElement te = (TypeElement)element;
                String name = te.getQualifiedName().toString();
                model.setJavaType(name);
                break;
            }
        }
        boolean deprecated = endpointClassElement.getAnnotation(Deprecated.class) != null;
        model.setDeprecated(deprecated);
        Object var13_15 = null;
        if (endpointClassElement.getAnnotation(Metadata.class) != null) {
            String string = endpointClassElement.getAnnotation(Metadata.class).deprecationNote();
        }
        model.setDeprecationNote((String)var13_17);
        if (model.getJavaType() == null) {
            model.setJavaType("@@@JAVATYPE@@@");
        }
        model.setDescription("@@@DESCRIPTION@@@");
        model.setGroupId("@@@GROUPID@@@");
        model.setArtifactId("@@@ARTIFACTID@@@");
        model.setVersionId("@@@VERSIONID@@@");
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement typeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, endpointClassElement.getQualifiedName().toString());
        if (typeElement != null && (doc = elementUtils.getDocComment(typeElement)) != null && !Strings.isNullOrEmpty(doc = JsonSchemaHelper.sanitizeDescription(doc, true))) {
            model.setDescription(doc);
        }
        return model;
    }

    protected void findComponentClassProperties(PrintWriter writer, RoundEnvironment roundEnv, ComponentModel componentModel, Set<ComponentOption> componentOptions, TypeElement classElement, String prefix, Map<String, Object> parentData, String nestedTypeName, String nestedFieldName) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (true) {
            TypeMirror superclass;
            Metadata componentAnnotation;
            if ((componentAnnotation = classElement.getAnnotation(Metadata.class)) != null && Objects.equals("verifiers", componentAnnotation.label())) {
                componentModel.setVerifiers(componentAnnotation.enums());
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
            for (ExecutableElement method : methods) {
                boolean isEnum;
                boolean isSetter;
                String methodName = method.getSimpleName().toString();
                boolean deprecated = method.getAnnotation(Deprecated.class) != null;
                Metadata metadata = method.getAnnotation(Metadata.class);
                if (metadata != null && metadata.skip()) continue;
                String deprecationNote = null;
                if (metadata != null) {
                    deprecationNote = metadata.deprecationNote();
                }
                if (!(isSetter = methodName.startsWith("set") && method.getParameters().size() == 1 & method.getReturnType().getKind().equals((Object)TypeKind.VOID)) || "setEndpointClass".equals(methodName) || "setCamelContext".equals(methodName) || "setEndpointHeaderFilterStrategy".equals(methodName) || "setApplicationContext".equals(methodName) || EndpointAnnotationProcessor.isGroovyMetaClassProperty(method)) continue;
                String fieldName = methodName.substring(3);
                VariableElement field = AnnotationProcessorHelper.findFieldElement(classElement, fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1));
                if (field != null && metadata == null) {
                    metadata = field.getAnnotation(Metadata.class);
                }
                if (metadata != null && metadata.skip()) continue;
                boolean required = metadata != null && metadata.required();
                String label = metadata != null ? metadata.label() : null;
                boolean secret = metadata != null && metadata.secret();
                String displayName = metadata != null ? metadata.displayName() : null;
                String defaultValue = metadata != null ? metadata.defaultValue() : null;
                String defaultValueNote = null;
                ExecutableElement setter = method;
                String name = fieldName;
                name = prefix + name;
                TypeMirror fieldType = setter.getParameters().get(0).asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeName);
                String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, method, fieldName, name, classElement, false);
                if (Strings.isNullOrEmpty(docComment)) {
                    String string = docComment = metadata != null ? metadata.description() : null;
                }
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = "setHeaderFilterStrategy".equals(methodName) ? HEADER_FILTER_STRATEGY_JAVADOC : "";
                }
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                if (metadata != null && !Strings.isNullOrEmpty(metadata.enums())) {
                    String[] values;
                    isEnum = true;
                    for (String val : values = metadata.enums().split(",")) {
                        enums.add(val);
                    }
                } else {
                    TypeElement enumClass;
                    boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                    if (isEnum && (enumClass = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                        List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                        for (VariableElement var : fields) {
                            String val;
                            if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                            val = var.toString();
                            enums.add(val);
                        }
                    }
                }
                if (metadata != null && !Strings.isNullOrEmpty(metadata.javaType())) {
                    fieldTypeName = metadata.javaType();
                }
                String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                ComponentOption option = new ComponentOption(name, displayName, fieldTypeName, required, defaultValue, defaultValueNote, docComment.trim(), deprecated, deprecationNote, secret, group, label, isEnum, enums, nestedTypeName, nestedFieldName);
                componentOptions.add(option);
            }
            TypeElement baseTypeElement = null;
            if (parentData == null && (superclass = classElement.getSuperclass()) != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    protected void findClassProperties(PrintWriter writer, RoundEnvironment roundEnv, ComponentModel componentModel, Set<EndpointPath> endpointPaths, Set<EndpointOption> endpointOptions, TypeElement classElement, String prefix, String excludeProperties, Map<String, Object> parentData, String nestedTypeName, String nestedFieldName) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (true) {
            TypeMirror superclass;
            List<VariableElement> fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
            for (VariableElement fieldElement : fieldElements) {
                boolean isEnum;
                String displayName;
                Metadata metadata = fieldElement.getAnnotation(Metadata.class);
                if (metadata != null && metadata.skip()) continue;
                boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
                String deprecationNote = null;
                if (metadata != null) {
                    deprecationNote = metadata.deprecationNote();
                }
                Boolean secret = metadata != null ? Boolean.valueOf(metadata.secret()) : null;
                UriPath path = fieldElement.getAnnotation(UriPath.class);
                String fieldName = fieldElement.getSimpleName().toString();
                if (path != null) {
                    boolean isEnum2;
                    String displayName2;
                    String name = path.name();
                    if (Strings.isNullOrEmpty(name)) {
                        name = fieldName;
                    }
                    if (EndpointAnnotationProcessor.excludeProperty(excludeProperties, name = prefix + name)) continue;
                    String defaultValue = path.defaultValue();
                    if (Strings.isNullOrEmpty(defaultValue) && metadata != null) {
                        defaultValue = metadata.defaultValue();
                    }
                    boolean required = metadata != null && metadata.required();
                    String label = path.label();
                    if (Strings.isNullOrEmpty(label) && metadata != null) {
                        label = metadata.label();
                    }
                    if (Strings.isNullOrEmpty(displayName2 = path.displayName())) {
                        displayName2 = metadata != null ? metadata.displayName() : null;
                    }
                    TypeMirror fieldType = fieldElement.asType();
                    String fieldTypeName = fieldType.toString();
                    TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeName);
                    String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, false);
                    if (Strings.isNullOrEmpty(docComment)) {
                        docComment = path.description();
                    }
                    LinkedHashSet<String> enums = new LinkedHashSet<String>();
                    if (!Strings.isNullOrEmpty(path.enums())) {
                        String[] values;
                        isEnum2 = true;
                        for (String val : values = path.enums().split(",")) {
                            enums.add(val);
                        }
                    } else {
                        TypeElement enumClass;
                        boolean bl = isEnum2 = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                        if (isEnum2 && (enumClass = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                            List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                            for (VariableElement var : fields) {
                                String val;
                                if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                                val = var.toString();
                                enums.add(val);
                            }
                        }
                    }
                    if (!Strings.isNullOrEmpty(path.javaType())) {
                        fieldTypeName = path.javaType();
                    }
                    boolean isSecret = secret != null && secret != false || path.secret();
                    String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                    EndpointPath ep = new EndpointPath(name, displayName2, fieldTypeName, required, defaultValue, docComment, deprecated, deprecationNote, isSecret, group, label, isEnum2, enums);
                    endpointPaths.add(ep);
                }
                UriParam param = fieldElement.getAnnotation(UriParam.class);
                fieldName = fieldElement.getSimpleName().toString();
                if (param == null) continue;
                String name = param.name();
                if (Strings.isNullOrEmpty(name)) {
                    name = fieldName;
                }
                if (EndpointAnnotationProcessor.excludeProperty(excludeProperties, name = prefix + name)) continue;
                String paramOptionalPrefix = param.optionalPrefix();
                String paramPrefix = param.prefix();
                boolean multiValue = param.multiValue();
                String defaultValue = param.defaultValue();
                if (defaultValue == null && metadata != null) {
                    defaultValue = metadata.defaultValue();
                }
                String defaultValueNote = param.defaultValueNote();
                boolean required = metadata != null && metadata.required();
                String label = param.label();
                if (Strings.isNullOrEmpty(label) && metadata != null) {
                    label = metadata.label();
                }
                if (Strings.isNullOrEmpty(displayName = param.displayName())) {
                    displayName = metadata != null ? metadata.displayName() : null;
                }
                TypeMirror fieldType = fieldElement.asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeName);
                UriParams fieldParams = null;
                if (fieldTypeElement != null) {
                    fieldParams = fieldTypeElement.getAnnotation(UriParams.class);
                }
                if (fieldParams != null) {
                    String nestedPrefix = prefix;
                    String extraPrefix = fieldParams.prefix();
                    if (!Strings.isNullOrEmpty(extraPrefix)) {
                        nestedPrefix = nestedPrefix + extraPrefix;
                    }
                    nestedTypeName = fieldTypeName;
                    nestedFieldName = fieldElement.getSimpleName().toString();
                    this.findClassProperties(writer, roundEnv, componentModel, endpointPaths, endpointOptions, fieldTypeElement, nestedPrefix, excludeProperties, null, nestedTypeName, nestedFieldName);
                    nestedTypeName = null;
                    nestedFieldName = null;
                    continue;
                }
                String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, false);
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = param.description();
                }
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = "";
                }
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                if (!Strings.isNullOrEmpty(param.enums())) {
                    String[] values;
                    isEnum = true;
                    for (String val : values = param.enums().split(",")) {
                        enums.add(val);
                    }
                } else {
                    TypeElement enumClass;
                    boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                    if (isEnum && (enumClass = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                        List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                        for (VariableElement var : fields) {
                            String val;
                            if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                            val = var.toString();
                            enums.add(val);
                        }
                    }
                }
                if (!Strings.isNullOrEmpty(param.javaType())) {
                    fieldTypeName = param.javaType();
                }
                boolean isSecret = secret != null && secret != false || param.secret();
                String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                EndpointOption option = new EndpointOption(name, displayName, fieldTypeName, required, defaultValue, defaultValueNote, docComment.trim(), paramOptionalPrefix, paramPrefix, multiValue, deprecated, deprecationNote, isSecret, group, label, isEnum, enums, nestedTypeName, nestedFieldName);
                endpointOptions.add(option);
            }
            TypeElement baseTypeElement = null;
            if (parentData == null && (superclass = classElement.getSuperclass()) != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    private static boolean excludeProperty(String excludeProperties, String name) {
        String[] excludes;
        for (String exclude : excludes = excludeProperties.split(",")) {
            if (!name.equals(exclude)) continue;
            return true;
        }
        return false;
    }

    private static boolean secureAlias(String scheme, String alias) {
        if (scheme.equals(alias)) {
            return false;
        }
        return (scheme + "s").equals(alias);
    }

    private static boolean isGroovyMetaClassProperty(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (!"setMetaClass".equals(methodName)) {
            return false;
        }
        if (method.getReturnType() instanceof DeclaredType) {
            DeclaredType returnType = (DeclaredType)method.getReturnType();
            return "groovy.lang.MetaClass".equals(returnType.asElement().getSimpleName());
        }
        return method.toString().contains("(groovy.lang.MetaClass)");
    }
}

