/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.CoreEipAnnotationProcessorHelper;
import org.apache.camel.tools.apt.PropertyPlaceholderGenerator;
import org.apache.camel.tools.apt.SpringAnnotationProcessorHelper;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"javax.xml.bind.annotation.*", "org.apache.camel.spi.Label"})
public class ModelAnnotationProcessor
extends AbstractCamelAnnotationProcessor {
    private CoreEipAnnotationProcessorHelper coreProcessor = new CoreEipAnnotationProcessorHelper();
    private SpringAnnotationProcessorHelper springProcessor = new SpringAnnotationProcessorHelper();

    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(XmlRootElement.class);
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.WARNING, String.format("Found %d elements annotated with XmlRootElement", elements.size()));
        Set coreElements = elements.stream().filter(new Predicate<Element>(){

            @Override
            public boolean test(Element element) {
                if (element instanceof TypeElement) {
                    TypeElement classElement = (TypeElement)element;
                    String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
                    return javaTypeName.startsWith("org.apache.camel.model");
                }
                return false;
            }
        }).collect(Collectors.toSet());
        messager.printMessage(Diagnostic.Kind.WARNING, String.format("Found %d core elements", coreElements.size()));
        Set springElements = elements.stream().filter(new Predicate<Element>(){

            @Override
            public boolean test(Element element) {
                if (element instanceof TypeElement) {
                    TypeElement classElement = (TypeElement)element;
                    String javaTypeName = Strings.canonicalClassName(classElement.getQualifiedName().toString());
                    return javaTypeName.startsWith("org.apache.camel.spring") || javaTypeName.startsWith("org.apache.camel.core.xml");
                }
                return false;
            }
        }).collect(Collectors.toSet());
        messager.printMessage(Diagnostic.Kind.WARNING, String.format("Found %d spring elements", springElements.size()));
        TreeSet<String> propertyPlaceholderDefinitions = new TreeSet<String>(String::compareToIgnoreCase);
        for (TypeElement classElement : coreElements) {
            this.coreProcessor.processModelClass(this.processingEnv, roundEnv, classElement, propertyPlaceholderDefinitions);
        }
        for (TypeElement classElement : springElements) {
            this.springProcessor.processModelClass(this.processingEnv, roundEnv, classElement);
        }
        if (!propertyPlaceholderDefinitions.isEmpty()) {
            messager.printMessage(Diagnostic.Kind.WARNING, String.format("Generating placeholder definitions helper for %d definitions", propertyPlaceholderDefinitions.size()));
            PropertyPlaceholderGenerator.generatePropertyPlaceholderDefinitionsHelper(this.processingEnv, roundEnv, propertyPlaceholderDefinitions);
        }
    }
}

