/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.view.RouteDotGenerator;

public class DotViewTest
extends ContextTestSupport {
    protected String outputDirectory = "target/site/cameldoc";

    public void testGenerateFiles() throws Exception {
        RouteDotGenerator generator = new RouteDotGenerator(this.outputDirectory);
        generator.drawRoutes(this.context);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.context.addRoutes(new MulticastRoute());
        this.context.addRoutes(new PipelineRoute());
        this.context.addRoutes(new ChoiceRoute());
        this.context.addRoutes(new FilterRoute());
        this.context.addRoutes(new ComplexRoute());
    }

    static class ComplexRoute
    extends RouteBuilder {
        ComplexRoute() {
        }

        public void configure() throws Exception {
            ((ProcessorType)this.from("file:target/xyz?noop=true").filter(this.header("foo").isEqualTo("bar")).recipientList(this.header("bar"))).splitter(XPathBuilder.xpath("/invoice/lineItems")).throttler(3L).to("mock:result");
        }
    }

    static class FilterRoute
    extends RouteBuilder {
        FilterRoute() {
        }

        public void configure() throws Exception {
            this.from("file:target/foo/bar?noop=true").filter(this.header("foo").isEqualTo("bar")).to("file:target/xyz?noop=true");
        }
    }

    static class ChoiceRoute
    extends RouteBuilder {
        ChoiceRoute() {
        }

        public void configure() throws Exception {
            ((ChoiceType)this.from("file:target/foo/xyz?noop=true").choice().when(XPathBuilder.xpath("/person/city = 'London'")).to("file:target/messages/uk")).otherwise().to("file:target/messages/others");
        }
    }

    static class PipelineRoute
    extends RouteBuilder {
        PipelineRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:pipeline.in").to("seda:pipeline.out1", "seda:pipeline.out2", "seda:pipeline.out3");
        }
    }

    static class MulticastRoute
    extends RouteBuilder {
        MulticastRoute() {
        }

        public void configure() throws Exception {
            this.from("seda:multicast.in").multicast().to("seda:multicast.out1", "seda:multicast.out2", "seda:multicast.out3");
        }
    }
}

