/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRouteBuilder
extends RouteBuilder {
    private List<String> fromUris = new ArrayList<String>();
    private List<String> toUris = new ArrayList<String>();
    private Class beanType;
    private String beanClass;
    private String beanRef;
    private String beanMethod;

    @Override
    public void configure() throws Exception {
        if (this.fromUris.isEmpty()) {
            throw new IllegalArgumentException("the fromUris property must contain at least one valid URI");
        }
        for (String fromUri : this.fromUris) {
            RouteType route = this.from(fromUri);
            this.addBeanCall(route);
            for (String toUri : this.toUris) {
                route = route.to(toUri);
            }
        }
    }

    public void setFromUri(String uri) {
        this.setFromUris(this.singletonList(uri));
    }

    public void setToUri(String uri) {
        this.setToUris(this.singletonList(uri));
    }

    public List<String> getFromUris() {
        return this.fromUris;
    }

    public void setFromUris(List<String> fromUris) {
        this.fromUris = fromUris;
    }

    public List<String> getToUris() {
        return this.toUris;
    }

    public void setToUris(List<String> toUris) {
        this.toUris = toUris;
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(String beanClass) {
        this.beanClass = beanClass;
    }

    public String getBeanRef() {
        return this.beanRef;
    }

    public void setBeanRef(String beanRef) {
        this.beanRef = beanRef;
    }

    public Class getBeanType() {
        if (this.beanType == null && this.beanClass != null) {
            this.beanType = ObjectHelper.loadClass(this.beanClass, this.getClass().getClassLoader());
        }
        return this.beanType;
    }

    public void setBeanType(Class beanType) {
        this.beanType = beanType;
    }

    public String getBeanMethod() {
        return this.beanMethod;
    }

    public void setBeanMethod(String beanMethod) {
        this.beanMethod = beanMethod;
    }

    protected void addBeanCall(ProcessorType route) {
        Class type = this.getBeanType();
        if (type != null) {
            route = this.beanMethod != null ? route.bean(type, this.beanMethod) : route.bean(type);
        } else if (this.beanRef != null) {
            route = this.beanMethod != null ? route.beanRef(this.beanRef, this.beanMethod) : route.beanRef(this.beanRef);
        }
    }

    protected List<String> singletonList(String value) {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(value);
        return uris;
    }
}

