/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.Main;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.SimpleRouteBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainTest
extends TestCase {
    private static final transient Log LOG = LogFactory.getLog(MainTest.class);

    public void testMain() throws Exception {
        SimpleRouteBuilder builder = new SimpleRouteBuilder();
        builder.setFromUri("file://src/test/data?noop=true");
        builder.setBeanClass("org.apache.camel.spring.example.MyProcessor");
        builder.setToUri("mock:results");
        Main main = new Main();
        main.addRouteBuilder(builder);
        main.start();
        List<SpringCamelContext> contextList = main.getCamelContexts();
        MainTest.assertNotNull(contextList);
        MainTest.assertEquals((String)"size", (int)1, (int)contextList.size());
        SpringCamelContext camelContext = contextList.get(0);
        MockEndpoint endpoint = camelContext.getEndpoint("mock:results", MockEndpoint.class);
        endpoint.expectedMessageCount(2);
        endpoint.assertIsSatisfied();
        List<Exchange> list = endpoint.getReceivedExchanges();
        LOG.debug((Object)("Received: " + list));
        main.stop();
    }
}

