/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryType;
import org.apache.camel.processor.MyValidator;

public class ValidationFinallyBlockNoCatchTest
extends ContextTestSupport {
    protected Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint allEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.allEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.allEndpoint);
    }

    public void testInvalidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(0);
        this.allEndpoint.expectedMessageCount(6);
        this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.allEndpoint);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.allEndpoint = this.resolveMandatoryEndpoint("mock:all", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TryType tryType = (TryType)((TryType)this.from("direct:start").tryBlock().process(ValidationFinallyBlockNoCatchTest.this.validator)).to("mock:valid");
                tryType.finallyBlock().to("mock:all");
            }
        };
    }
}

