/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class ThreadTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;
    private CountDownLatch continueProcessing = new CountDownLatch(1);

    public void testSimpleAsyncThreadCase() throws Exception {
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(1);
            }
        }, new AsyncCallback(){

            public void done(boolean doneSynchronously) {
                ThreadTest.this.log.info((Object)"Exchange completed.");
            }
        });
        this.resultEndpoint.expectedMessageCount(0);
        this.resultEndpoint.assertIsSatisfied();
        this.continueProcessing.countDown();
        this.resultEndpoint.expectedMessageCount(1);
        this.resultEndpoint.assertIsSatisfied();
    }

    public void testSimpleSyncThreadCase() throws Exception {
        this.releaseProcessingLatchIn(1000L);
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(1);
            }
        });
        this.resultEndpoint.expectedMessageCount(1);
        this.resultEndpoint.assertIsSatisfied();
    }

    public void testQueuedUpExchangesCompleteOnShutdown() throws Exception {
        int exchangeCount = 10;
        final CountDownLatch completedExchanges = new CountDownLatch(exchangeCount);
        final Exchange[] exchanges = new Exchange[exchangeCount];
        for (int i = 0; i < exchangeCount; ++i) {
            final int index = i;
            exchanges[i] = this.template.send("direct:a", new Processor(){

                public void process(Exchange exchange) {
                    Message in = exchange.getIn();
                    in.setBody(1);
                }
            }, new AsyncCallback(){

                public void done(boolean doneSynchronously) {
                    ThreadTest.this.log.debug((Object)("Completed: " + index + ", exception: " + exchanges[index].getException()));
                    completedExchanges.countDown();
                }
            });
        }
        this.resultEndpoint.expectedMessageCount(0);
        this.resultEndpoint.assertIsSatisfied();
        this.releaseProcessingLatchIn(1000L);
        this.stopCamelContext();
        ThreadTest.assertTrue((boolean)completedExchanges.await(5L, TimeUnit.SECONDS));
    }

    protected void releaseProcessingLatchIn(final long delay) {
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(delay);
                    ThreadTest.this.continueProcessing.countDown();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.inheritErrorHandler(false);
                ((ProcessorType)this.from("direct:a").thread(1).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ThreadTest.this.continueProcessing.await();
                    }
                })).to("mock:result");
            }
        };
    }
}

