/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import java.util.TreeSet;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.MyAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class SplitterTest
extends ContextTestSupport {
    public void testSendingAMessageUsingMulticastReceivesItsOwnExchange() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived("James", "Guillaume", "Hiram", "Rob");
        this.template.send("direct:seqential", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody("James,Guillaume,Hiram,Rob");
                in.setHeader("foo", "bar");
            }
        });
        this.assertMockEndpointsSatisifed();
        List<Exchange> list = resultEndpoint.getReceivedExchanges();
        for (int i = 0; i < 4; ++i) {
            Exchange exchange = list.get(i);
            Message in = exchange.getIn();
            this.assertMessageHeader(in, "org.apache.camel.splitCounter", i);
            this.assertMessageHeader(in, "org.apache.camel.splitSize", 4);
        }
    }

    public void testSpliterWithAggregationStrategy() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived("James", "Guillaume", "Hiram", "Rob", "Roman");
        Object result = this.template.send("direct:seqential", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody("James,Guillaume,Hiram,Rob,Roman");
                in.setHeader("foo", "bar");
            }
        });
        this.assertMockEndpointsSatisifed();
        Message out = result.getOut();
        SplitterTest.assertEquals((Object)"Roman", (Object)out.getBody());
        this.assertMessageHeader(out, "foo", "bar");
        this.assertMessageHeader(out, "org.apache.camel.splitCounter", 4);
    }

    public void testEmptyBody() {
        Object result = this.template.send("direct:seqential", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setHeader("foo", "bar");
            }
        });
        SplitterTest.assertNull((Object)result.getOut(false));
    }

    public void testSendingAMessageUsingMulticastReceivesItsOwnExchangeParallel() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates(this.body());
        resultEndpoint.expectedMessageCount(4);
        this.template.send("direct:parallel", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody("James,Guillaume,Hiram,Rob");
                in.setHeader("foo", "bar");
            }
        });
        this.assertMockEndpointsSatisifed();
        List<Exchange> list = resultEndpoint.getReceivedExchanges();
        TreeSet<Integer> numbersFound = new TreeSet<Integer>();
        String[] NAMES = new String[]{"James", "Guillaume", "Hiram", "Rob"};
        for (int i = 0; i < 4; ++i) {
            Exchange exchange = list.get(i);
            Message in = exchange.getIn();
            Integer splitCounter = in.getHeader("org.apache.camel.splitCounter", Integer.class);
            numbersFound.add(splitCounter);
            SplitterTest.assertEquals((Object)NAMES[splitCounter], (Object)in.getBody());
            this.assertMessageHeader(in, "org.apache.camel.splitSize", 4);
        }
        SplitterTest.assertEquals((int)4, (int)numbersFound.size());
    }

    public void testSpliterWithAggregationStrategyParallel() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        Object result = this.template.send("direct:parallel", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody("James,Guillaume,Hiram,Rob,Roman");
                in.setHeader("foo", "bar");
            }
        });
        this.assertMockEndpointsSatisifed();
        Message out = result.getOut();
        this.assertMessageHeader(out, "foo", "bar");
        SplitterTest.assertEquals((Object)5, (Object)result.getProperty("aggregated", Integer.class));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:seqential").splitter(this.body().tokenize(","), new UseLatestAggregationStrategy()).to("mock:result");
                this.from("direct:parallel").splitter(this.body().tokenize(","), new MyAggregationStrategy(), true).to("mock:result");
            }
        };
    }
}

