/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.FilterType;
import org.apache.camel.model.FromType;
import org.apache.camel.model.LoadBalanceType;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.ProcessorRef;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RecipientListType;
import org.apache.camel.model.ResequencerType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.RoutingSlipType;
import org.apache.camel.model.SplitterType;
import org.apache.camel.model.ToType;
import org.apache.camel.model.WhenType;
import org.apache.camel.model.XmlTestSupport;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalanceStrategy;
import org.apache.camel.model.loadbalancer.StickyLoadBalanceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParseTest
extends XmlTestSupport {
    public void testParseSimpleRouteXml() throws Exception {
        RouteType route = this.assertOneRoute("simpleRoute.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo("to", route, "seda:b");
    }

    public void testParseProcessorXml() throws Exception {
        RouteType route = this.assertOneRoute("processor.xml");
        this.assertFrom(route, "seda:a");
        this.assertProcessor(route, "myProcessor");
    }

    public void testParseProcessorWithFilterXml() throws Exception {
        RouteType route = this.assertOneRoute("processorWithFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterType filter = this.assertFilter(route);
        this.assertExpression(filter.getExpression(), "juel", "in.header.foo == 'bar'");
    }

    public void testParseProcessorWithHeaderFilterXml() throws Exception {
        RouteType route = this.assertOneRoute("processorWithHeaderFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterType filter = this.assertFilter(route);
        this.assertExpression(filter.getExpression(), "header", "foo");
    }

    public void testParseProcessorWithElFilterXml() throws Exception {
        RouteType route = this.assertOneRoute("processorWithElFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterType filter = this.assertFilter(route);
        this.assertExpression(filter.getExpression(), "el", "$in.header.foo == 'bar'");
    }

    public void testParseProcessorWithGroovyFilterXml() throws Exception {
        RouteType route = this.assertOneRoute("processorWithGroovyFilter.xml");
        this.assertFrom(route, "seda:a");
        FilterType filter = this.assertFilter(route);
        this.assertExpression(filter.getExpression(), "groovy", "in.headers.any { h -> h.startsWith('foo')}");
    }

    public void testParseRecipientListXml() throws Exception {
        RouteType route = this.assertOneRoute("dynamicRecipientList.xml");
        this.assertFrom(route, "seda:a");
        RecipientListType node = this.assertRecipientList(route);
        this.assertExpression(node.getExpression(), "header", "foo");
    }

    public void testParseStaticRecipientListXml() throws Exception {
        RouteType route = this.assertOneRoute("staticRecipientList.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo(route, "seda:b", "seda:c", "seda:d");
    }

    public void testParseRoutingSlipXml() throws Exception {
        RouteType route = this.assertOneRoute("routingSlip.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipType node = this.assertRoutingSlip(route);
        XmlParseTest.assertEquals((String)"routingSlipHeader", (String)node.getHeaderName());
        XmlParseTest.assertEquals((String)",", (String)node.getUriDelimiter());
    }

    public void testParseRoutingSlipWithHeaderSetXml() throws Exception {
        RouteType route = this.assertOneRoute("routingSlipHeaderSet.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipType node = this.assertRoutingSlip(route);
        XmlParseTest.assertEquals((String)"theRoutingSlipHeader", (String)node.getHeaderName());
        XmlParseTest.assertEquals((String)",", (String)node.getUriDelimiter());
    }

    public void testParseRoutingSlipWithHeaderAndDelimiterSetXml() throws Exception {
        RouteType route = this.assertOneRoute("routingSlipHeaderAndDelimiterSet.xml");
        this.assertFrom(route, "seda:a");
        RoutingSlipType node = this.assertRoutingSlip(route);
        XmlParseTest.assertEquals((String)"theRoutingSlipHeader", (String)node.getHeaderName());
        XmlParseTest.assertEquals((String)"#", (String)node.getUriDelimiter());
    }

    public void xtestParseRouteWithInterceptorXml() throws Exception {
        RouteType route = this.assertOneRoute("routeWithInterceptor.xml");
        this.assertFrom(route, "seda:a");
        this.assertChildTo("to", route, "seda:d");
        this.assertInterceptorRefs(route, "interceptor1", "interceptor2");
    }

    public void testParseRouteWithChoiceXml() throws Exception {
        RouteType route = this.assertOneRoute("routeWithChoice.xml");
        this.assertFrom(route, "seda:a");
        ChoiceType choice = this.assertChoice(route);
        List<WhenType> whens = this.assertListSize(choice.getWhenClauses(), 2);
        this.assertChildTo("when(0)", whens.get(0), "seda:b");
        this.assertChildTo("when(1)", whens.get(1), "seda:c");
        OtherwiseType otherwise = choice.getOtherwise();
        XmlParseTest.assertNotNull((String)"Otherwise is null", (Object)otherwise);
        this.assertChildTo("otherwise", otherwise, "seda:d");
    }

    public void testParseSplitterXml() throws Exception {
        RouteType route = this.assertOneRoute("splitter.xml");
        this.assertFrom(route, "seda:a");
        SplitterType splitter = this.assertSplitter(route);
        this.assertExpression(splitter.getExpression(), "xpath", "/foo/bar");
        this.assertChildTo("to", splitter, "seda:b");
    }

    public void testParseLoadBalance() throws Exception {
        RouteType route = this.assertOneRoute("routeWithLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceType loadBalance = this.assertLoadBalancer(route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be RoundRobinLoadBalanceStrategy", (boolean)(loadBalance.getLoadBalancerType() instanceof RoundRobinLoadBalanceStrategy));
    }

    public void testParseStickyLoadBalance() throws Exception {
        RouteType route = this.assertOneRoute("routeWithStickyLoadBalance.xml");
        this.assertFrom(route, "seda:a");
        LoadBalanceType loadBalance = this.assertLoadBalancer(route);
        XmlParseTest.assertEquals((String)"Here should have 3 output here", (int)3, (int)loadBalance.getOutputs().size());
        XmlParseTest.assertTrue((String)"The loadBalancer shoud be StickyLoadBalanceStrategy", (boolean)(loadBalance.getLoadBalancerType() instanceof StickyLoadBalanceStrategy));
        StickyLoadBalanceStrategy strategy = (StickyLoadBalanceStrategy)loadBalance.getLoadBalancerType();
        XmlParseTest.assertNotNull((String)"the expression should not be null ", (Object)strategy.getExpressionType());
    }

    public void testParseBatchResequencerXml() throws Exception {
        RouteType route = this.assertOneRoute("resequencerBatch.xml");
        ResequencerType resequencer = this.assertResequencer(route);
        XmlParseTest.assertNull((Object)resequencer.getStreamConfig());
        XmlParseTest.assertNotNull((Object)resequencer.getBatchConfig());
        XmlParseTest.assertEquals((int)500, (int)resequencer.getBatchConfig().getBatchSize());
        XmlParseTest.assertEquals((long)2000L, (long)resequencer.getBatchConfig().getBatchTimeout());
    }

    public void testParseStreamResequencerXml() throws Exception {
        RouteType route = this.assertOneRoute("resequencerStream.xml");
        ResequencerType resequencer = this.assertResequencer(route);
        XmlParseTest.assertNotNull((Object)resequencer.getStreamConfig());
        XmlParseTest.assertNull((Object)resequencer.getBatchConfig());
        XmlParseTest.assertEquals((int)100, (int)resequencer.getStreamConfig().getCapacity());
        XmlParseTest.assertEquals((long)2000L, (long)resequencer.getStreamConfig().getTimeout());
    }

    protected RouteType assertOneRoute(String uri) throws JAXBException {
        RouteContainer context = this.assertParseAsJaxb(uri);
        RouteType route = this.assertOneElement(context.getRoutes());
        return route;
    }

    protected void assertFrom(RouteType route, String uri) {
        FromType from = this.assertOneElement(route.getInputs());
        XmlParseTest.assertEquals((String)"From URI", (String)uri, (String)from.getUri());
    }

    protected void assertChildTo(String message, ProcessorType<?> route, String uri) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        ToType value = this.assertIsInstanceOf(ToType.class, processor);
        String text = message + "To URI";
        this.log.info((Object)("Testing: " + text + " is equal to: " + uri + " for processor: " + processor));
        XmlParseTest.assertEquals((String)text, (String)uri, (String)value.getUri());
    }

    protected void assertTo(String message, ProcessorType processor, String uri) {
        ToType value = this.assertIsInstanceOf(ToType.class, processor);
        String text = message + "To URI";
        this.log.info((Object)("Testing: " + text + " is equal to: " + uri + " for processor: " + processor));
        XmlParseTest.assertEquals((String)text, (String)uri, (String)value.getUri());
    }

    protected void assertChildTo(ProcessorType route, String ... uris) {
        List<ProcessorType<?>> list = this.assertListSize(route.getOutputs(), uris.length);
        int idx = 0;
        for (String uri : uris) {
            this.assertTo("output[" + idx + "] ", list.get(idx++), uri);
        }
    }

    protected void assertProcessor(ProcessorType<?> route, String processorRef) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        ProcessorRef to = this.assertIsInstanceOf(ProcessorRef.class, processor);
        XmlParseTest.assertEquals((String)"Processor ref", (String)processorRef, (String)to.getRef());
    }

    protected FilterType assertFilter(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(FilterType.class, processor);
    }

    protected RecipientListType assertRecipientList(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(RecipientListType.class, processor);
    }

    protected RoutingSlipType assertRoutingSlip(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(RoutingSlipType.class, processor);
    }

    protected ChoiceType assertChoice(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(ChoiceType.class, processor);
    }

    protected SplitterType assertSplitter(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(SplitterType.class, processor);
    }

    protected LoadBalanceType assertLoadBalancer(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(LoadBalanceType.class, processor);
    }

    protected ResequencerType assertResequencer(ProcessorType<?> route) {
        ProcessorType<?> processor = this.assertOneElement(route.getOutputs());
        return this.assertIsInstanceOf(ResequencerType.class, processor);
    }

    protected void assertExpression(ExpressionType expression, String language, String languageExpression) {
        XmlParseTest.assertNotNull((String)"Expression should not be null!", (Object)expression);
        XmlParseTest.assertEquals((String)"Expression language", (String)language, (String)expression.getLanguage());
        XmlParseTest.assertEquals((String)"Expression", (String)languageExpression, (String)expression.getExpression());
    }

    protected void assertInterceptorRefs(ProcessorType route, String ... names) {
    }
}

