/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.Marshaller;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.RoutesType;
import org.apache.camel.model.XmlTestSupport;
import org.apache.camel.model.language.GroovyExpression;

public class GenerateXmlTest
extends XmlTestSupport {
    public void testCreateSimpleXml() throws Exception {
        RoutesType context = new RoutesType();
        RouteType route = context.route();
        route.from("seda:a");
        route.filter("juel", "in.header.foo == 'bar'").to("seda:b");
        this.dump(context);
    }

    public void testGroovyFilterXml() throws Exception {
        RoutesType context = new RoutesType();
        RouteType route = context.route();
        route.from("seda:a");
        route.interceptors("interceptor1", "interceptor2");
        route.filter(new GroovyExpression("in.headers.any { h -> h.startsWith('foo') }")).to("seda:b");
        List<ProcessorType<?>> list = route.getOutputs();
        GenerateXmlTest.assertEquals((String)("Size of list: " + list), (int)1, (int)list.size());
        this.dump(context);
    }

    protected void dump(RouteContainer context) throws Exception {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)context, (Writer)buffer);
        this.log.info((Object)("Created: " + buffer));
    }
}

