/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import javax.xml.xpath.XPathConstants;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.builder.xml.XPathLanguage;
import org.apache.camel.spi.Language;

public class XPathTest
extends LanguageTestSupport {
    public void testExpressions() throws Exception {
        this.assertExpression("in:body()", "<hello id='m123'>world!</hello>");
        this.assertExpression("in:header('foo')", "abc");
        this.assertExpression("$foo", "abc");
    }

    public void testPredicates() throws Exception {
        this.assertPredicate("in:header('foo') = 'abc'");
        this.assertPredicate("$foo = 'abc'");
        this.assertPredicate("$foo = 'bar'", false);
    }

    protected String getLanguageName() {
        return "xpath";
    }

    protected Language assertResolveLanguage(String languageName) {
        XPathLanguage answer = new XPathLanguage();
        answer.setResultType(XPathConstants.STRING);
        return answer;
    }
}

