/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.LanguageTestSupport;

public class SimpleTest
extends LanguageTestSupport {
    public void testSimpleExpressions() throws Exception {
        this.assertExpression("body", "<hello id='m123'>world!</hello>");
        this.assertExpression("in.body", "<hello id='m123'>world!</hello>");
        this.assertExpression("in.header.foo", "abc");
        this.assertExpression("header.foo", "abc");
    }

    public void testComplexExpressions() throws Exception {
        this.assertExpression("hey ${in.header.foo}", "hey abc");
        this.assertExpression("hey ${in.header.foo}!", "hey abc!");
        this.assertExpression("hey ${in.header.foo}-${in.header.foo}!", "hey abc-abc!");
        this.assertExpression("hey ${in.header.foo}${in.header.foo}", "hey abcabc");
        this.assertExpression("${in.header.foo}${in.header.foo}", "abcabc");
        this.assertExpression("${in.header.foo}", "abc");
        this.assertExpression("${in.header.foo}!", "abc!");
    }

    public void testInvalidComplexExpression() throws Exception {
        try {
            this.assertExpression("hey ${foo", "bad expression!");
            SimpleTest.fail((String)"Should have thrown an exception!");
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Caught expected exception: " + e), (Throwable)e);
        }
    }

    public void testPredicates() throws Exception {
        this.assertPredicate("body");
        this.assertPredicate("header.foo");
        this.assertPredicate("header.madeUpHeader", false);
    }

    protected String getLanguageName() {
        return "simple";
    }
}

