/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import javax.naming.Context;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Message;

public class BeanTest
extends LanguageTestSupport {
    public void testSimpleExpressions() throws Exception {
        this.assertExpression("foo.cheese", "abc");
    }

    public void testPredicates() throws Exception {
        this.assertPredicate("foo.isFooHeaderAbc");
    }

    protected String getLanguageName() {
        return "bean";
    }

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)new MyBean());
        return context;
    }

    public static class MyBean {
        public Object cheese(Exchange exchange) {
            Message in = exchange.getIn();
            return in.getHeader("foo");
        }

        public boolean isFooHeaderAbc(@Header(name="foo") String foo) {
            return "abc".equals(foo);
        }
    }
}

