/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import junit.framework.Assert;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class CustomExchangePatternTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    public void testInOut() throws Exception {
        final ExchangePattern expectedPattern = ExchangePattern.InOut;
        this.template.send("direct:start", expectedPattern, new Processor(){

            public void process(Exchange exchange) throws Exception {
                Assert.assertEquals((String)"MEP", (Object)((Object)expectedPattern), (Object)((Object)exchange.getPattern()));
                exchange.getIn().setBody("<hello>world!</hello>");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
        this.assertReceivedExpectedPattern(expectedPattern);
    }

    public void testInOnly() throws Exception {
        ExchangePattern expectedPattern = ExchangePattern.InOnly;
        this.template.send("direct:start", expectedPattern, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody("<hello>world!</hello>");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
        this.assertReceivedExpectedPattern(expectedPattern);
    }

    public void testInOutViaUri() throws Exception {
        final ExchangePattern expectedPattern = ExchangePattern.InOut;
        this.template.send("direct:start?exchangePattern=InOut", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Assert.assertEquals((String)"MEP", (Object)((Object)expectedPattern), (Object)((Object)exchange.getPattern()));
                exchange.getIn().setBody("<hello>world!</hello>");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
        this.assertReceivedExpectedPattern(expectedPattern);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        this.resultEndpoint.expectedMessageCount(1);
    }

    protected void assertReceivedExpectedPattern(ExchangePattern expectedPattern) {
        List<Exchange> list = this.resultEndpoint.getReceivedExchanges();
        Exchange exchange = list.get(0);
        CustomExchangePatternTest.assertEquals((String)"MEP", (Object)((Object)expectedPattern), (Object)((Object)exchange.getPattern()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
                this.from("direct:start?exchangePattern=InOut").to("mock:result");
            }
        };
    }
}

