/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.StreamCacheConverter;

public class StreamCacheConverterTest
extends TestCase {
    private static final String TEST_FILE = "org/apache/camel/converter/stream/test.xml";
    private StreamCacheConverter converter;

    protected void setUp() throws Exception {
        super.setUp();
        this.converter = new StreamCacheConverter();
    }

    public void testConvertToStreamCacheStreamSource() throws TransformerException, FileNotFoundException {
        StreamSource source = new StreamSource(this.getTestFileStream());
        StreamSource cache = (StreamSource)((Object)this.converter.convertToStreamCache(source));
        XmlConverter converter = new XmlConverter();
        StreamCacheConverterTest.assertNotNull((Object)converter.toString(cache));
        StreamCacheConverterTest.assertNotNull((Object)converter.toString(cache));
    }

    public void testConvertToStreamCacheInputStream() throws IOException {
        InputStream is = this.getTestFileStream();
        InputStream cache = (InputStream)((Object)this.converter.convertToStreamCache(is));
        StreamCacheConverterTest.assertNotNull((Object)IOConverter.toString(cache));
        StreamCacheConverterTest.assertNotNull((Object)IOConverter.toString(cache));
    }

    protected InputStream getTestFileStream() {
        InputStream answer = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        StreamCacheConverterTest.assertNotNull((String)"Should have found the file: org/apache/camel/converter/stream/test.xml on the classpath", (Object)answer);
        return answer;
    }
}

