/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.ReflectionInjector;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JaxpTest
extends TestCase {
    private static final transient Log LOG = LogFactory.getLog(JaxpTest.class);
    protected TypeConverter converter = new DefaultTypeConverter(new ReflectionInjector());

    public void testConvertToDocument() throws Exception {
        Document document = this.converter.convertTo(Document.class, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        JaxpTest.assertNotNull((Object)document);
        LOG.debug((Object)("Found document: " + document));
        String text = this.converter.convertTo(String.class, document);
        JaxpTest.assertTrue((String)("Converted to String: " + text), (boolean)text.endsWith("<hello>world!</hello>"));
    }

    public void testConvertToSource() throws Exception {
        Source source = this.converter.convertTo(Source.class, "<hello>world!</hello>");
        JaxpTest.assertNotNull((Object)source);
        LOG.debug((Object)("Found document: " + source));
    }

    public void testStreamSourceToDomSource() throws Exception {
        StreamSource streamSource = new StreamSource(new StringReader("<hello>world!</hello>"));
        DOMSource domSource = this.converter.convertTo(DOMSource.class, streamSource);
        JaxpTest.assertNotNull((String)"Could not convert to a DOMSource!", (Object)domSource);
        LOG.debug((Object)("Found document: " + domSource));
    }

    public void testNodeToSourceThenToInputStream() throws Exception {
        Document document = this.converter.convertTo(Document.class, "<?xml version=\"1.0\"?><hello>world!</hello>");
        Element element = document.getDocumentElement();
        Source source = this.converter.convertTo(Source.class, element);
        JaxpTest.assertNotNull((String)"Could not convert from Node to Source!", (Object)source);
        LOG.debug((Object)("Found source: " + source));
        InputStream in = this.converter.convertTo(InputStream.class, source);
        JaxpTest.assertNotNull((String)"Could not convert from Source to InputStream!", (Object)in);
        String actualText = IOConverter.toString(in);
        JaxpTest.assertEquals((String)"Text", (String)"<hello>world!</hello>", (String)actualText);
    }
}

