/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pojo;

import junit.framework.TestCase;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.component.pojo.ISay;
import org.apache.camel.component.pojo.SayService;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.jndi.JndiContext;

public class PojoRouteTest
extends TestCase {
    public void testPojoRoutes() throws Exception {
        JndiContext context = new JndiContext();
        context.bind("bye", (Object)new SayService("Good Bye!"));
        DefaultCamelContext camelContext = new DefaultCamelContext(context);
        camelContext.addRoutes(new RouteBuilder(){

            public void configure() {
                this.from("direct:hello").to("pojo:bye");
            }
        });
        camelContext.start();
        Endpoint endpoint = camelContext.getEndpoint("direct:hello");
        ISay proxy = ProxyHelper.createProxy(endpoint, ISay.class);
        String rc = proxy.say();
        PojoRouteTest.assertEquals((String)"Good Bye!", (String)rc);
        camelContext.stop();
    }
}

