/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;

public final class CxfSoapBinding {
    private CxfSoapBinding() {
    }

    public static org.apache.cxf.message.Message getCxfInMessage(Exchange exchange, boolean isClient) {
        Object body;
        MessageImpl answer = new MessageImpl();
        org.apache.cxf.message.Exchange cxfExchange = exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        Message message = null;
        message = isClient ? exchange.getOut() : exchange.getIn();
        assert (message != null);
        if (cxfExchange == null) {
            cxfExchange = new ExchangeImpl();
            exchange.setProperty("org.apache.cxf.message.exchange", cxfExchange);
        }
        if ((body = message.getBody(InputStream.class)) == null) {
            body = message.getBody();
        }
        if (body instanceof InputStream) {
            answer.setContent(InputStream.class, body);
        }
        answer.putAll(message.getHeaders());
        answer.setExchange(cxfExchange);
        cxfExchange.setInMessage((org.apache.cxf.message.Message)answer);
        return answer;
    }

    public static org.apache.cxf.message.Message getCxfOutMessage(Exchange exchange, boolean isClient) {
        org.apache.cxf.message.Exchange cxfExchange = exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        assert (cxfExchange != null);
        Endpoint cxfEndpoint = (Endpoint)cxfExchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = cxfEndpoint.getBinding().createMessage();
        outMessage.setExchange(cxfExchange);
        cxfExchange.setOutMessage(outMessage);
        Message message = null;
        message = isClient ? exchange.getIn() : exchange.getOut();
        Object body = message.getBody(Source.class);
        if (body == null) {
            body = message.getBody();
        }
        if (body instanceof Source) {
            outMessage.setContent(Source.class, body);
        }
        outMessage.putAll(message.getHeaders());
        return outMessage;
    }
}

