/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.invoker.CxfClient;
import org.apache.camel.component.cxf.invoker.CxfClientFactoryBean;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.camel.component.cxf.invoker.InvokingContextFactory;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfProducer
extends DefaultProducer<CxfExchange> {
    private CxfEndpoint endpoint;
    private Client client;
    private DataFormat dataFormat;

    public CxfProducer(CxfEndpoint endpoint) throws CamelException {
        super(endpoint);
        this.endpoint = endpoint;
        this.dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        this.client = this.dataFormat.equals((Object)DataFormat.POJO) ? this.createClientFormClientFactoryBean(null) : this.createClientForStreamMessge();
    }

    private Client createClientForStreamMessge() throws CamelException {
        CxfClientFactoryBean cfb = new CxfClientFactoryBean();
        Class serviceClass = null;
        if (this.endpoint.isSpringContextEndpoint()) {
            CxfEndpointBean cxfEndpointBean = this.endpoint.getCxfEndpointBean();
            serviceClass = cxfEndpointBean.getServiceClass();
        } else {
            try {
                serviceClass = ClassLoaderUtils.loadClass((String)this.endpoint.getServiceClass(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new CamelException(e);
            }
        }
        boolean jsr181Enabled = CxfEndpointUtils.hasWebServiceAnnotation(serviceClass);
        cfb.setJSR181Enabled(jsr181Enabled);
        this.dataFormat = CxfEndpointUtils.getDataFormat(this.endpoint);
        ArrayList<AbstractDataFormatFeature> features = new ArrayList<AbstractDataFormatFeature>();
        if (this.dataFormat.equals((Object)DataFormat.MESSAGE)) {
            features.add(new MessageDataFormatFeature());
        }
        if (this.dataFormat.equals((Object)DataFormat.PAYLOAD)) {
            features.add(new PayLoadDataFormatFeature());
        }
        cfb.setFeatures(features);
        return this.createClientFormClientFactoryBean(cfb);
    }

    /*
     * Unable to fully structure code
     */
    private Client createClientFormClientFactoryBean(ClientFactoryBean cfb) throws CamelException {
        bus = BusFactory.getDefaultBus();
        if (this.endpoint.isSpringContextEndpoint()) {
            cxfEndpointBean = this.endpoint.getCxfEndpointBean();
            if (cfb == null) {
                cfb = CxfEndpointUtils.getClientFactoryBean(cxfEndpointBean.getServiceClass());
            }
            this.endpoint.configure(cfb);
            if (cxfEndpointBean.getServiceName() != null) {
                cfb.setServiceName(cxfEndpointBean.getServiceName());
            }
            if (cxfEndpointBean.getEndpointName() != null) {
                cfb.setEndpointName(cxfEndpointBean.getEndpointName());
            }
        } else {
            if (null != this.endpoint.getServiceClass()) {
                try {
                    serviceClass = ClassLoaderUtils.loadClass((String)this.endpoint.getServiceClass(), this.getClass());
                    if (cfb == null) {
                        cfb = CxfEndpointUtils.getClientFactoryBean(serviceClass);
                    }
                    cfb.setAddress(this.endpoint.getAddress());
                    if (null != this.endpoint.getServiceClass()) {
                        cfb.setServiceClass(ObjectHelper.loadClass(this.endpoint.getServiceClass()));
                    }
                    if (null == this.endpoint.getWsdlURL()) ** GOTO lbl31
                    cfb.setWsdlURL(this.endpoint.getWsdlURL());
                }
                catch (ClassNotFoundException e) {
                    throw new CamelException(e);
                }
            } else {
                if (cfb == null) {
                    cfb = new ClientFactoryBean();
                }
                if (null != this.endpoint.getWsdlURL()) {
                    cfb.setWsdlURL(this.endpoint.getWsdlURL());
                } else {
                    throw new CamelException("Insufficiency of the endpoint info");
                }
            }
lbl31:
            // 3 sources

            if (this.endpoint.getServiceName() != null) {
                cfb.setServiceName(CxfEndpointUtils.getServiceName(this.endpoint));
            }
            if (this.endpoint.getPortName() != null) {
                cfb.setEndpointName(CxfEndpointUtils.getPortName(this.endpoint));
            }
            if (this.endpoint.getWsdlURL() != null) {
                cfb.setWsdlURL(this.endpoint.getWsdlURL());
            }
        }
        cfb.setBus(bus);
        return cfb.create();
    }

    @Override
    public void process(Exchange exchange) {
        CxfExchange cxfExchange = (CxfExchange)this.endpoint.createExchange(exchange);
        this.process(cxfExchange);
        exchange.copyFrom(cxfExchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(CxfExchange exchange) {
        CxfBinding cxfBinding = this.endpoint.getBinding();
        Message inMessage = cxfBinding.createCxfMessage(exchange);
        try {
            if (this.dataFormat.equals((Object)DataFormat.POJO)) {
                ArrayList parameters = (ArrayList)inMessage.getContent(List.class);
                if (parameters == null) {
                    parameters = new ArrayList();
                }
                String operationName = (String)inMessage.get((Object)"operationName");
                String operationNameSpace = (String)inMessage.get((Object)"operationNameSpace");
                MessageImpl response = new MessageImpl();
                if (operationName == null) throw new RuntimeCamelException("Can't find the operation name in the message!");
                try {
                    Object[] result = null;
                    if (operationNameSpace == null) {
                        result = this.client.invoke(operationName, parameters.toArray());
                    } else {
                        QName operation = new QName(operationNameSpace, operationName);
                        result = this.client.invoke(operation, parameters.toArray());
                    }
                    response.setContent(Object[].class, (Object)result);
                    cxfBinding.storeCxfResponse(exchange, (Message)response);
                    return;
                }
                catch (Exception ex) {
                    response.setContent(Exception.class, (Object)ex);
                    cxfBinding.storeCxfFault(exchange, (Message)response);
                }
                return;
            } else {
                org.apache.cxf.message.Exchange ex = exchange.getExchange();
                if (ex == null) {
                    ex = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange");
                    exchange.setExchange(ex);
                }
                if (ex == null) {
                    ex = new ExchangeImpl();
                    exchange.setExchange(ex);
                }
                assert (ex != null);
                InvokingContext invokingContext = (InvokingContext)ex.get(InvokingContext.class);
                if (invokingContext == null) {
                    invokingContext = InvokingContextFactory.createContext(this.dataFormat);
                    ex.put(InvokingContext.class, (Object)invokingContext);
                }
                Map<Class, Object> params = invokingContext.getRequestContent(inMessage);
                CxfClient cxfClient = (CxfClient)this.client;
                BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
                MessageImpl response = null;
                if (boi == null) {
                    response = new MessageImpl();
                } else {
                    Endpoint ep = (Endpoint)ex.get(Endpoint.class);
                    response = ep.getBinding().createMessage();
                }
                response.setExchange(ex);
                HashMap<String, Object> context = new HashMap<String, Object>();
                HashMap requestContext = new HashMap();
                HashMap responseContext = new HashMap();
                context.put("RequestContext", requestContext);
                context.put("ResponseContext", responseContext);
                try {
                    Object result = cxfClient.dispatch(params, context, ex);
                    ex.setOutMessage((Message)response);
                    invokingContext.setResponseContent((Message)response, result);
                    response.putAll(responseContext);
                    cxfBinding.storeCxfResponse(exchange, (Message)response);
                    return;
                }
                catch (Exception e) {
                    response.setContent(Exception.class, (Object)e);
                    cxfBinding.storeCxfFault(exchange, (Message)response);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }
}

