/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewInstanceTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected JndiContext jndiContext;

    public void testSendMessageToDifferentBeans() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedBodiesReceived(1, 2);
        this.template.sendBody("direct:start", (Object)"first");
        this.jndiContext.unbind("myBean");
        this.jndiContext.bind("myBean", (Object)new MyBean());
        this.template.sendBody("direct:start", (Object)"second");
        this.assertMockEndpointsSatisifed();
    }

    protected Context createJndiContext() throws Exception {
        this.jndiContext = new JndiContext();
        this.jndiContext.bind("myBean", (Object)new MyBean());
        return this.jndiContext;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:start").beanRef("myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        private static int counter;
        private int id = MyBean.generateId();

        protected static synchronized int generateId() {
            return ++counter;
        }

        public String toString() {
            return "MyBean[" + this.id + "]";
        }

        public int read(@Body String body) {
            LOG.info((Object)("read() method called with: " + body + " on " + this));
            return this.id;
        }
    }
}

