/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.util.jndi.JndiContext;
import org.easymock.EasyMock;

public class ChainedBeanInvocationTest
extends ContextTestSupport {
    protected MyBean beanMock;

    protected void setUp() throws Exception {
        this.beanMock = (MyBean)EasyMock.createStrictMock(MyBean.class);
        super.setUp();
    }

    protected Context createJndiContext() throws Exception {
        JndiContext context = new JndiContext();
        context.bind("myBean", (Object)this.beanMock);
        return context;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorType)((ProcessorType)this.from("direct:start").to("bean:myBean?methodName=a")).bean(ChainedBeanInvocationTest.this.beanMock, "b")).beanRef("myBean", "c");
                ((ProcessorType)((ProcessorType)((ProcessorType)((ProcessorType)((ProcessorType)this.from("direct:start2").to("bean:myBean?methodName=a")).to("bean:myBean")).bean(ChainedBeanInvocationTest.this.beanMock, "b")).bean(ChainedBeanInvocationTest.this.beanMock)).beanRef("myBean", "c")).beanRef("myBean");
            }
        };
    }

    public void testNormalInvocation() throws Throwable {
        this.beanMock.a();
        this.beanMock.b();
        this.beanMock.c();
        EasyMock.replay((Object[])new Object[]{this.beanMock});
        DefaultExchange result = this.template.send("direct:start", new DefaultExchange(this.context));
        if (result.getException() != null) {
            throw result.getException();
        }
        EasyMock.verify((Object[])new Object[]{this.beanMock});
    }

    public void testNoMethodSpecified() throws Throwable {
        this.beanMock.a();
        EasyMock.replay((Object[])new Object[]{this.beanMock});
        DefaultExchange result = this.template.send("direct:start2", new DefaultExchange(this.context));
        ChainedBeanInvocationTest.assertNotNull((Object)result.getException());
        ChainedBeanInvocationTest.assertEquals(result.getException().getClass(), IllegalStateException.class);
        EasyMock.verify((Object[])new Object[]{this.beanMock});
    }

    public void testMethodHeaderSet() throws Exception {
        this.beanMock.a();
        this.beanMock.d();
        this.beanMock.b();
        this.beanMock.d();
        this.beanMock.c();
        this.beanMock.d();
        EasyMock.replay((Object[])new Object[]{this.beanMock});
        this.template.sendBodyAndHeader("direct:start2", (Object)"test", "org.apache.camel.MethodName", (Object)"d");
        EasyMock.verify((Object[])new Object[]{this.beanMock});
    }

    public static interface MyBean {
        public void a();

        public void b();

        public void c();

        public void d();
    }
}

