/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.Assert;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BodyAnnotationToDisambiguateMethodsTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        BodyAnnotationToDisambiguateMethodsTest.assertEquals((String)("bean body: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        public String body;

        public void bar(String body) {
            Assert.fail((String)("bar() called with: " + body));
        }

        public void foo(@Body String body) {
            this.body = body;
            LOG.info((Object)("foo() method called on " + this));
        }

        public void wrongMethod(String body) {
            Assert.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

