/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.MyInterceptorProcessor;
import org.apache.camel.builder.MyProcessor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.processor.idempotent.MemoryMessageIdRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteBuilderTest
extends TestSupport {
    protected Processor myProcessor = new MyProcessor();
    protected DelegateProcessor interceptor1;
    protected DelegateProcessor interceptor2;

    protected List<Route> buildSimpleRoute() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").to("seda:b");
            }
        };
        return this.getRouteList(builder);
    }

    public void testSimpleRoute() throws Exception {
        List<Route> routes = this.buildSimpleRoute();
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            SendProcessor sendProcessor = this.assertIsInstanceOf(SendProcessor.class, processor);
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)"seda:b", (String)sendProcessor.getDestination().getEndpointUri());
        }
    }

    protected List<Route> buildSimpleRouteWithHeaderPredicate() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").filter(this.header("foo").isEqualTo("bar")).to("seda:b");
            }
        };
        return this.getRouteList(builder);
    }

    public void testSimpleRouteWithHeaderPredicate() throws Exception {
        List<Route> routes = this.buildSimpleRouteWithHeaderPredicate();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            FilterProcessor filterProcessor = this.assertIsInstanceOf(FilterProcessor.class, processor);
            SendProcessor sendProcessor = this.assertIsInstanceOf(SendProcessor.class, this.unwrapErrorHandler(filterProcessor.getProcessor()));
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)"seda:b", (String)sendProcessor.getDestination().getEndpointUri());
        }
    }

    protected List<Route> buildSimpleRouteWithChoice() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)this.from("seda:a").choice().when(this.header("foo").isEqualTo("bar")).to("seda:b")).when(this.header("foo").isEqualTo("cheese")).to("seda:c")).otherwise().to("seda:d");
            }
        };
        return this.getRouteList(builder);
    }

    public void testSimpleRouteWithChoice() throws Exception {
        List<Route> routes = this.buildSimpleRouteWithChoice();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            ChoiceProcessor choiceProcessor = this.assertIsInstanceOf(ChoiceProcessor.class, processor);
            List<FilterProcessor> filters = choiceProcessor.getFilters();
            RouteBuilderTest.assertEquals((String)"Should be two when clauses", (int)2, (int)filters.size());
            FilterProcessor filter1 = filters.get(0);
            this.assertSendTo(filter1.getProcessor(), "seda:b");
            FilterProcessor filter2 = filters.get(1);
            this.assertSendTo(filter2.getProcessor(), "seda:c");
            this.assertSendTo(choiceProcessor.getOtherwise(), "seda:d");
        }
    }

    protected List<Route> buildCustomProcessor() throws Exception {
        this.myProcessor = new Processor(){

            public void process(Exchange exchange) {
                RouteBuilderTest.this.log.debug((Object)("Called with exchange: " + exchange));
            }
        };
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").process(RouteBuilderTest.this.myProcessor);
            }
        };
        return this.getRouteList(builder);
    }

    public void testCustomProcessor() throws Exception {
        List<Route> routes = this.buildCustomProcessor();
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            RouteBuilderTest.assertEquals((String)"Should be called with my processor", (Object)this.myProcessor, (Object)processor);
        }
    }

    protected List<Route> buildCustomProcessorWithFilter() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").filter(this.header("foo").isEqualTo("bar")).process(RouteBuilderTest.this.myProcessor);
            }
        };
        return this.getRouteList(builder);
    }

    public void testCustomProcessorWithFilter() throws Exception {
        List<Route> routes = this.buildCustomProcessorWithFilter();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            FilterProcessor filterProcessor = this.assertIsInstanceOf(FilterProcessor.class, processor);
            RouteBuilderTest.assertEquals((String)"Should be called with my processor", (Object)this.myProcessor, (Object)this.unwrapErrorHandler(filterProcessor.getProcessor()));
        }
    }

    protected List<Route> buildWireTap() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").to("seda:tap", "seda:b");
            }
        };
        return this.getRouteList(builder);
    }

    public void testWireTap() throws Exception {
        List<Route> routes = this.buildWireTap();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            MulticastProcessor multicastProcessor = this.assertIsInstanceOf(MulticastProcessor.class, processor);
            ArrayList<Processor> endpoints = new ArrayList<Processor>(multicastProcessor.getProcessors());
            RouteBuilderTest.assertEquals((String)"Should have 2 endpoints", (int)2, (int)endpoints.size());
            this.assertSendToProcessor((Processor)endpoints.get(0), "seda:tap");
            this.assertSendToProcessor((Processor)endpoints.get(1), "seda:b");
        }
    }

    protected List<Route> buildRouteWithInterceptor() throws Exception {
        this.interceptor1 = new DelegateProcessor(){};
        this.interceptor2 = new MyInterceptorProcessor();
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                ((ProcessorType)((ProcessorType)this.from("seda:a").intercept(RouteBuilderTest.this.interceptor1)).intercept(RouteBuilderTest.this.interceptor2)).to("seda:d");
            }
        };
        return this.getRouteList(builder);
    }

    public void testRouteWithInterceptor() throws Exception {
        List<Route> routes = this.buildRouteWithInterceptor();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            DelegateProcessor p1 = this.assertIsInstanceOf(DelegateProcessor.class, processor);
            processor = p1.getProcessor();
            DelegateProcessor p2 = this.assertIsInstanceOf(DelegateProcessor.class, processor);
            this.assertSendTo(p2.getProcessor(), "seda:d");
        }
    }

    public void testComplexExpressions() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").filter(this.header("foo").isEqualTo(123)).to("seda:b");
                this.from("seda:a").filter(this.header("bar").isGreaterThan(45)).to("seda:b");
            }
        };
        List<Route> routes = this.getRouteList(builder);
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)2, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            this.log.debug((Object)("processor: " + processor));
        }
    }

    protected List<Route> buildStaticRecipientList() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").to("seda:b", "seda:c", "seda:d");
            }
        };
        return this.getRouteList(builder);
    }

    protected List<Route> buildDynamicRecipientList() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").recipientList(this.header("foo"));
            }
        };
        return this.getRouteList(builder);
    }

    public void testRouteDynamicReceipentList() throws Exception {
        List<Route> routes = this.buildDynamicRecipientList();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            RecipientList p1 = this.assertIsInstanceOf(RecipientList.class, processor);
        }
    }

    protected List<Route> buildSplitter() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").splitter(RouteBuilderTest.this.bodyAs(String.class).tokenize("\n")).to("seda:b");
            }
        };
        return this.getRouteList(builder);
    }

    public void testSplitter() throws Exception {
        List<Route> routes = this.buildSplitter();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            Splitter p1 = this.assertIsInstanceOf(Splitter.class, processor);
        }
    }

    protected List<Route> buildIdempotentConsumer() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").idempotentConsumer(this.header("myMessageId"), MemoryMessageIdRepository.memoryMessageIdRepository(200)).to("seda:b");
            }
        };
        return this.getRouteList(builder);
    }

    public void testIdempotentConsumer() throws Exception {
        List<Route> routes = this.buildIdempotentConsumer();
        this.log.debug((Object)("Created routes: " + routes));
        RouteBuilderTest.assertEquals((String)"Number routes created", (int)1, (int)routes.size());
        for (Route route : routes) {
            Endpoint key = route.getEndpoint();
            RouteBuilderTest.assertEquals((String)"From endpoint", (String)"seda:a", (String)key.getEndpointUri());
            Processor processor = this.getProcessorWithoutErrorHandler(route);
            IdempotentConsumer idempotentConsumer = this.assertIsInstanceOf(IdempotentConsumer.class, processor);
            RouteBuilderTest.assertEquals((String)"messageIdExpression", (String)"header(myMessageId)", (String)idempotentConsumer.getMessageIdExpression().toString());
            this.assertIsInstanceOf(MemoryMessageIdRepository.class, idempotentConsumer.getMessageIdRepository());
            SendProcessor sendProcessor = this.assertIsInstanceOf(SendProcessor.class, this.unwrapErrorHandler(idempotentConsumer.getNextProcessor()));
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)"seda:b", (String)sendProcessor.getDestination().getEndpointUri());
        }
    }

    protected void assertSendTo(Processor processor, String uri) {
        if (!(processor instanceof SendProcessor)) {
            processor = this.unwrapErrorHandler(processor);
        }
        SendProcessor sendProcessor = this.assertIsInstanceOf(SendProcessor.class, processor);
        RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)uri, (String)sendProcessor.getDestination().getEndpointUri());
    }

    protected void assertSendToProcessor(Processor processor, String uri) {
        if (!(processor instanceof Producer)) {
            processor = this.unwrapErrorHandler(processor);
        }
        if (processor instanceof SendProcessor) {
            this.assertSendTo(processor, uri);
        } else {
            Producer producer = this.assertIsInstanceOf(Producer.class, processor);
            RouteBuilderTest.assertEquals((String)"Endpoint URI", (String)uri, (String)producer.getEndpoint().getEndpointUri());
        }
    }

    protected Processor getProcessorWithoutErrorHandler(Route route) {
        EventDrivenConsumerRoute consumerRoute = this.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
        Processor processor = this.unwrap(consumerRoute.getProcessor());
        return this.unwrapErrorHandler(processor);
    }

    protected Processor unwrapErrorHandler(Processor processor) {
        if (processor instanceof DeadLetterChannel) {
            DeadLetterChannel deadLetter = (DeadLetterChannel)processor;
            return deadLetter.getOutput();
        }
        return processor;
    }
}

