/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestSupport
extends TestCase {
    protected transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public <E extends Exchange> ValueBuilder<E> header(String name) {
        return Builder.header(name);
    }

    public ValueBuilder body() {
        return Builder.body();
    }

    public <T> ValueBuilder bodyAs(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public ValueBuilder outBody() {
        return Builder.outBody();
    }

    public <T> ValueBuilder outBodyAs(Class<T> type) {
        return Builder.outBodyAs(type);
    }

    public ValueBuilder faultBody() {
        return Builder.faultBody();
    }

    public <T> ValueBuilder faultBodyAs(Class<T> type) {
        return Builder.faultBodyAs(type);
    }

    public ValueBuilder systemProperty(String name) {
        return Builder.systemProperty(name);
    }

    public ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty(name, defaultValue);
    }

    protected <T> T assertIsInstanceOf(Class<T> expectedType, Object value) {
        TestSupport.assertNotNull((String)("Expected an instance of type: " + expectedType.getName() + " but was null"), (Object)value);
        TestSupport.assertTrue((String)("object should be a " + expectedType.getName() + " but was: " + value + " with type: " + value.getClass().getName()), (boolean)expectedType.isInstance(value));
        return expectedType.cast(value);
    }

    protected void assertEndpointUri(Endpoint<Exchange> endpoint, String uri) {
        TestSupport.assertNotNull((String)("Endpoint is null when expecting endpoint for: " + uri), endpoint);
        TestSupport.assertEquals((String)("Endoint uri for: " + endpoint), (String)uri, (String)endpoint.getEndpointUri());
    }

    protected Object assertInMessageHeader(Exchange exchange, String name, Object expected) {
        return this.assertMessageHeader(exchange.getIn(), name, expected);
    }

    protected Object assertOutMessageHeader(Exchange exchange, String name, Object expected) {
        return this.assertMessageHeader(exchange.getOut(), name, expected);
    }

    protected void assertInMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        TestSupport.assertNotNull((String)"Should have a response exchange!", (Object)exchange);
        if (expected == null) {
            actual = ExchangeHelper.getMandatoryInBody(exchange);
            TestSupport.assertEquals((String)("in body of: " + exchange), (Object)expected, (Object)actual);
        } else {
            actual = ExchangeHelper.getMandatoryInBody(exchange, expected.getClass());
        }
        TestSupport.assertEquals((String)("in body of: " + exchange), (Object)expected, (Object)actual);
        this.log.debug((Object)("Received response: " + exchange + " with in: " + exchange.getIn()));
    }

    protected void assertOutMessageBodyEquals(Exchange exchange, Object expected) throws InvalidPayloadException {
        Object actual;
        TestSupport.assertNotNull((String)"Should have a response exchange!", (Object)exchange);
        if (expected == null) {
            actual = ExchangeHelper.getMandatoryOutBody(exchange);
            TestSupport.assertEquals((String)("output body of: " + exchange), (Object)expected, (Object)actual);
        } else {
            actual = ExchangeHelper.getMandatoryOutBody(exchange, expected.getClass());
        }
        TestSupport.assertEquals((String)("output body of: " + exchange), (Object)expected, (Object)actual);
        this.log.debug((Object)("Received response: " + exchange + " with out: " + exchange.getOut()));
    }

    protected Object assertMessageHeader(Message message, String name, Object expected) {
        Object value = message.getHeader(name);
        TestSupport.assertEquals((String)("Header: " + name + " on Message: " + message), (Object)expected, (Object)value);
        return value;
    }

    protected Object assertExpression(Expression expression, Exchange exchange, Object expected) {
        Object value = expression.evaluate(exchange);
        if (expected != null) {
            value = ExchangeHelper.convertToType(exchange, expected.getClass(), value);
        }
        this.log.debug((Object)("Evaluated expression: " + expression + " on exchange: " + exchange + " result: " + value));
        TestSupport.assertEquals((String)("Expression: " + expression + " on Exchange: " + exchange), (Object)expected, (Object)value);
        return value;
    }

    protected void assertPredicateMatches(Predicate predicate, Exchange exchange) {
        this.assertPredicate(predicate, exchange, true);
    }

    protected void assertPredicateDoesNotMatch(Predicate predicate, Exchange exchange) {
        try {
            predicate.assertMatches("Predicate should match", exchange);
        }
        catch (AssertionError e) {
            this.log.debug((Object)("Caught expected assertion error: " + e));
        }
        this.assertPredicate(predicate, exchange, false);
    }

    protected boolean assertPredicate(Predicate predicate, Exchange exchange, boolean expected) {
        if (expected) {
            predicate.assertMatches("Predicate failed", exchange);
        }
        boolean value = predicate.matches(exchange);
        this.log.debug((Object)("Evaluated predicate: " + predicate + " on exchange: " + exchange + " result: " + value));
        TestSupport.assertEquals((String)("Predicate: " + predicate + " on Exchange: " + exchange), (boolean)expected, (boolean)value);
        return value;
    }

    protected Endpoint resolveMandatoryEndpoint(CamelContext context, String uri) {
        Endpoint endpoint = context.getEndpoint(uri);
        TestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), (Object)endpoint);
        return endpoint;
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(CamelContext context, String uri, Class<T> endpointType) {
        T endpoint = context.getEndpoint(uri, endpointType);
        TestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), endpoint);
        return endpoint;
    }

    protected Exchange createExchangeWithBody(CamelContext camelContext, Object body) {
        DefaultExchange exchange = new DefaultExchange(camelContext);
        Message message = exchange.getIn();
        message.setHeader("testName", this.getName());
        message.setHeader("testClass", ((Object)((Object)this)).getClass().getName());
        message.setBody(body);
        return exchange;
    }

    protected <T> T assertOneElement(List<T> list) {
        TestSupport.assertEquals((String)("Size of list should be 1: " + list), (int)1, (int)list.size());
        return list.get(0);
    }

    protected <T> List<T> assertListSize(List<T> list, int size) {
        TestSupport.assertEquals((String)("List should be of size: " + size + " but is: " + list), (int)size, (int)list.size());
        return list;
    }

    protected List<Route> getRouteList(RouteBuilder builder) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes(builder);
        context.start();
        List<Route> answer = context.getRoutes();
        context.stop();
        return answer;
    }

    protected void assertStringContains(String text, String containedText) {
        TestSupport.assertNotNull((String)"Text should not be null!", (Object)text);
        TestSupport.assertTrue((String)("Text: " + text + " does not contain: " + containedText), (boolean)text.contains(containedText));
    }

    protected Processor unwrap(Processor processor) {
        while (true) {
            if (processor instanceof DelegateAsyncProcessor) {
                processor = ((DelegateAsyncProcessor)processor).getProcessor();
                continue;
            }
            if (!(processor instanceof DelegateProcessor)) break;
            processor = ((DelegateProcessor)processor).getProcessor();
        }
        return processor;
    }

    protected static void deleteDirectory(String file) {
        TestSupport.deleteDirectory(new File(file));
    }

    protected static void deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                TestSupport.deleteDirectory(files[i]);
            }
        }
        file.delete();
    }
}

