/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidTypeException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.util.CamelContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeHelper {
    private ExchangeHelper() {
    }

    public static <T> T getExchangeProperty(Exchange exchange, String propertyName, Class<T> type, T defaultValue) {
        T answer = exchange.getProperty(propertyName, type);
        if (answer == null) {
            return defaultValue;
        }
        return answer;
    }

    public static <E extends Exchange> Endpoint<E> resolveEndpoint(E exchange, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value instanceof Endpoint) {
            endpoint = (Endpoint)value;
        } else {
            String uri = value.toString();
            endpoint = CamelContextHelper.getMandatoryEndpoint(exchange.getContext(), uri);
        }
        return endpoint;
    }

    public static <T> T getMandatoryProperty(Exchange exchange, String propertyName, Class<T> type) throws NoSuchPropertyException {
        T answer = exchange.getProperty(propertyName, type);
        if (answer == null) {
            throw new NoSuchPropertyException(exchange, propertyName, type);
        }
        return answer;
    }

    public static Object getMandatoryInBody(Exchange exchange) throws InvalidPayloadException {
        Object answer = exchange.getIn().getBody();
        if (answer == null) {
            throw new InvalidPayloadException(exchange, Object.class);
        }
        return answer;
    }

    public static <T> T getMandatoryInBody(Exchange exchange, Class<T> type) throws InvalidPayloadException {
        T answer = exchange.getIn().getBody(type);
        if (answer == null) {
            throw new InvalidPayloadException(exchange, type);
        }
        return answer;
    }

    public static Object getMandatoryOutBody(Exchange exchange) throws InvalidPayloadException {
        Object answer = exchange.getOut().getBody();
        if (answer == null) {
            throw new InvalidPayloadException(exchange, Object.class);
        }
        return answer;
    }

    public static <T> T getMandatoryOutBody(Exchange exchange, Class<T> type) throws InvalidPayloadException {
        T answer = exchange.getOut().getBody(type);
        if (answer == null) {
            throw new InvalidPayloadException(exchange, type);
        }
        return answer;
    }

    public static <T> T convertToMandatoryType(Exchange exchange, Class<T> type, Object value) throws InvalidTypeException {
        T answer = ExchangeHelper.convertToType(exchange, type, value);
        if (answer == null) {
            throw new InvalidTypeException(exchange, value, type);
        }
        return answer;
    }

    public static <T> T convertToType(Exchange exchange, Class<T> type, Object value) {
        return exchange.getContext().getTypeConverter().convertTo(type, value);
    }

    public static void copyResults(Exchange result, Exchange source) {
        if (result != source) {
            Message out;
            result.setException(source.getException());
            Message fault = source.getFault(false);
            if (fault != null) {
                result.getFault(true).copyFrom(fault);
            }
            if ((out = source.getOut(false)) != null) {
                result.getOut(true).copyFrom(out);
            }
        }
    }

    public static boolean isInCapable(Exchange exchange) {
        ExchangePattern pattern = exchange.getPattern();
        return pattern != null && pattern.isInCapable();
    }

    public static boolean isOutCapable(Exchange exchange) {
        ExchangePattern pattern = exchange.getPattern();
        return pattern != null && pattern.isOutCapable();
    }

    public static <T> T newInstance(Exchange exchange, Class<T> type) {
        return exchange.getContext().getInjector().newInstance(type);
    }

    public static Map createVariableMap(Exchange exchange) {
        HashMap answer = new HashMap();
        ExchangeHelper.populateVariableMap(exchange, answer);
        return answer;
    }

    public static void populateVariableMap(Exchange exchange, Map map) {
        map.put("exchange", exchange);
        Message in = exchange.getIn();
        map.put("in", in);
        map.put("request", in);
        map.put("headers", in.getHeaders());
        map.put("body", in.getBody());
        if (ExchangeHelper.isOutCapable(exchange)) {
            Message out = exchange.getOut(true);
            map.put("out", out);
            map.put("response", out);
        }
        map.put("camelContext", exchange.getContext());
    }

    public static String getContentType(Exchange exchange) {
        return exchange.getIn().getHeader("Content-Type", String.class);
    }
}

