/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.MessageDriven;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.ReflectionUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="beanPostProcessor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelBeanPostProcessor.class);
    @XmlTransient
    private SpringCamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.injectFields(bean);
        this.injectMethods(bean);
        if (bean instanceof CamelContextAware) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            if (this.camelContext == null) {
                LOG.warn("No CamelContext defined yet so cannot inject into: " + bean);
            } else {
                contextAware.setCamelContext(this.camelContext);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SpringCamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(SpringCamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void injectFields(final Object bean) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                EndpointInject annotation = field.getAnnotation(EndpointInject.class);
                if (annotation != null) {
                    ReflectionUtils.setField(field, bean, CamelBeanPostProcessor.this.getEndpointInjectionValue(annotation, field.getType(), field.getName()));
                }
            }
        });
    }

    protected void injectMethods(final Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CamelBeanPostProcessor.this.setterInjection(method, bean);
                CamelBeanPostProcessor.this.consumerInjection(method, bean);
            }
        });
    }

    protected void setterInjection(Method method, Object bean) {
        Class<?>[] parameterTypes;
        EndpointInject annoation = method.getAnnotation(EndpointInject.class);
        if (annoation != null && (parameterTypes = method.getParameterTypes()) != null) {
            if (parameterTypes.length != 1) {
                LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method);
            } else {
                String propertyName = ObjectHelper.getPropertyName(method);
                Object value = this.getEndpointInjectionValue(annoation, parameterTypes[0], propertyName);
                ObjectHelper.invokeMethod(method, bean, value);
            }
        }
    }

    protected void consumerInjection(Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            }
        });
    }

    protected void consumerInjection(Method method, Object bean) {
        MessageDriven annotation = method.getAnnotation(MessageDriven.class);
        if (annotation != null) {
            LOG.info("Creating a consumer for: " + annotation);
            String injectionPointName = method.getName();
            Endpoint endpoint = this.getEndpointInjection(annotation.uri(), annotation.name(), injectionPointName);
            if (endpoint != null) {
                try {
                    Processor processor = this.createConsumerProcessor(bean, method, endpoint);
                    LOG.info("Created processor: " + processor);
                    Consumer consumer = endpoint.createConsumer(processor);
                    consumer.start();
                    this.onConsumerAdded(consumer);
                }
                catch (Exception e) {
                    LOG.warn(e);
                    throw new RuntimeCamelException(e);
                }
            }
        }
    }

    protected Processor createConsumerProcessor(Object pojo, Method method, Endpoint endpoint) {
        BeanProcessor answer = new BeanProcessor(pojo, this.getCamelContext());
        answer.setMethod(method);
        return answer;
    }

    protected void onConsumerAdded(Consumer consumer) {
        LOG.debug("Adding consumer: " + consumer);
    }

    protected Object getEndpointInjectionValue(EndpointInject annotation, Class<?> type, String injectionPointName) {
        Endpoint endpoint = this.getEndpointInjection(annotation.uri(), annotation.name(), injectionPointName);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint);
            }
            if (type.isAssignableFrom(CamelTemplate.class)) {
                return new CamelTemplate(this.getCamelContext(), endpoint);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint);
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject for " + endpoint);
        }
        return null;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint) {
        try {
            PollingConsumer pollingConsumer = endpoint.createPollingConsumer();
            pollingConsumer.start();
            return pollingConsumer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint) {
        try {
            Producer producer = endpoint.createProducer();
            producer.start();
            return producer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected Endpoint getEndpointInjection(String uri, String name, String injectionPointName) {
        Endpoint endpoint = null;
        if (ObjectHelper.isNotNullAndNonEmpty(uri)) {
            endpoint = this.camelContext.getEndpoint(uri);
        } else {
            if (ObjectHelper.isNullOrBlank(name)) {
                name = injectionPointName;
            }
            if ((endpoint = (Endpoint)this.applicationContext.getBean(name)) == null) {
                throw new NoSuchBeanDefinitionException(name);
            }
        }
        return endpoint;
    }
}

