/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collection;
import javax.management.JMException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.CamelNamingStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.model.RouteType;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationLifecycleStrategy
implements LifecycleStrategy {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationProcessor.class);
    private InstrumentationAgent agent;
    private CamelNamingStrategy namingStrategy;

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent) {
        this.agent = agent;
        this.setNamingStrategy(agent.getNamingStrategy());
    }

    @Override
    public void onContextCreate(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            try {
                DefaultCamelContext dc = (DefaultCamelContext)context;
                ManagedService ms = new ManagedService(dc);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(dc));
            }
            catch (JMException e) {
                LOG.warn("Could not register CamelContext MBean", e);
            }
        }
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        try {
            ManagedEndpoint me = new ManagedEndpoint(endpoint);
            this.agent.register(me, this.getNamingStrategy().getObjectName(me));
        }
        catch (JMException e) {
            LOG.warn("Could not register Endpoint MBean", e);
        }
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        for (Route route : routes) {
            try {
                ManagedRoute mr = new ManagedRoute(route);
                this.agent.register(mr, this.getNamingStrategy().getObjectName(mr));
            }
            catch (JMException e) {
                LOG.warn("Could not register Route MBean", e);
            }
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service) {
        if (service instanceof ServiceSupport) {
            try {
                ManagedService ms = new ManagedService((ServiceSupport)service);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(context, ms));
            }
            catch (JMException e) {
                LOG.warn("Could not register Service MBean", e);
            }
        }
    }

    @Override
    public void beforeStartRouteType(CamelContext context, RouteType routeType) {
        PerformanceCounter mc = new PerformanceCounter();
        routeType.intercept(new InstrumentationProcessor(mc));
    }

    public CamelNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(CamelNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

