/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Enumeration;
import java.util.Map;
import javax.mail.Header;
import javax.mail.MessagingException;
import org.apache.camel.Message;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.MessageHeaderAccessException;
import org.apache.camel.component.mail.MessageHeaderNamesAccessException;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMessage
extends DefaultMessage {
    private javax.mail.Message mailMessage;

    public MailMessage() {
    }

    public MailMessage(javax.mail.Message message) {
        this.mailMessage = message;
    }

    @Override
    public String toString() {
        if (this.mailMessage != null) {
            return "MailMessage: " + this.mailMessage;
        }
        return "MailMessage: " + this.getBody();
    }

    @Override
    public MailExchange getExchange() {
        return (MailExchange)super.getExchange();
    }

    @Override
    public MailMessage copy() {
        MailMessage answer = (MailMessage)super.copy();
        answer.mailMessage = this.mailMessage;
        return answer;
    }

    public javax.mail.Message getMessage() {
        return this.mailMessage;
    }

    public void setMessage(javax.mail.Message mailMessage) {
        this.mailMessage = mailMessage;
    }

    @Override
    public Object getHeader(String name) {
        String[] answer = null;
        if (this.mailMessage != null) {
            try {
                answer = this.mailMessage.getHeader(name);
            }
            catch (MessagingException e) {
                throw new MessageHeaderAccessException(name, e);
            }
        }
        if (answer == null) {
            return super.getHeader(name);
        }
        if (answer.length == 1) {
            return answer[0];
        }
        return answer;
    }

    @Override
    public MailMessage newInstance() {
        return new MailMessage();
    }

    @Override
    protected Object createBody() {
        if (this.mailMessage != null) {
            return this.getExchange().getBinding().extractBodyFromMail(this.getExchange(), this.mailMessage);
        }
        return null;
    }

    @Override
    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.mailMessage != null) {
            Enumeration names;
            try {
                names = this.mailMessage.getAllHeaders();
            }
            catch (MessagingException e) {
                throw new MessageHeaderNamesAccessException(e);
            }
            try {
                while (names.hasMoreElements()) {
                    Header header = (Header)names.nextElement();
                    String value = header.getValue();
                    String name = header.getName();
                    CollectionHelper.appendValue(map, name, value);
                }
            }
            catch (Throwable e) {
                throw new MessageHeaderNamesAccessException(e);
            }
        }
    }

    @Override
    public void copyFrom(Message that) {
        super.copyFrom(that);
        if (that instanceof MailMessage) {
            MailMessage mailMessage = (MailMessage)that;
            this.mailMessage = mailMessage.mailMessage;
        }
    }
}

