/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProducer;
import org.apache.camel.component.file.strategy.DeleteFileProcessStrategy;
import org.apache.camel.component.file.strategy.FileProcessStrategy;
import org.apache.camel.component.file.strategy.NoOpFileProcessStrategy;
import org.apache.camel.component.file.strategy.RenameFileProcessStrategy;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEndpoint
extends ScheduledPollEndpoint<FileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FileEndpoint.class);
    private File file;
    private FileProcessStrategy fileProcessStrategy;
    private boolean autoCreate = true;
    private boolean lock = true;
    private boolean delete;
    private boolean noop;
    private boolean append = true;
    private String moveNamePrefix;
    private String moveNamePostfix;
    private String[] excludedNamePrefixes = new String[]{"."};
    private String[] excludedNamePostfixes = new String[]{".cameLock"};
    private int bufferSize = 131072;
    private boolean ignoreFileNameHeader;

    protected FileEndpoint(File file, String endpointUri, FileComponent component) {
        super(endpointUri, component);
        this.file = file;
    }

    @Override
    public Producer<FileExchange> createProducer() throws Exception {
        FileProducer result = new FileProducer(this);
        return result;
    }

    @Override
    public Consumer<FileExchange> createConsumer(Processor file) throws Exception {
        FileConsumer result = new FileConsumer(this, file);
        this.configureConsumer(result);
        return result;
    }

    public FileExchange createExchange(File file) {
        return new FileExchange(this.getContext(), this.getExchangePattern(), file);
    }

    @Override
    public FileExchange createExchange() {
        return this.createExchange(this.getFile());
    }

    @Override
    public FileExchange createExchange(ExchangePattern pattern) {
        return new FileExchange(this.getContext(), pattern, this.file);
    }

    public void configureMessage(File file, Message message) {
        message.setBody(file);
        String path = file.getPath();
        String relativePath = path.substring(path.length());
        if (relativePath.startsWith(File.separator) || relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        message.setHeader("org.apache.camel.file.name", relativePath);
    }

    public File getFile() {
        if (this.autoCreate && !this.file.exists()) {
            this.file.mkdirs();
        }
        return this.file;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public FileProcessStrategy getFileStrategy() {
        if (this.fileProcessStrategy == null) {
            this.fileProcessStrategy = this.createFileStrategy();
            LOG.debug("" + this + " using strategy: " + this.fileProcessStrategy);
        }
        return this.fileProcessStrategy;
    }

    public void setFileStrategy(FileProcessStrategy fileProcessStrategy) {
        this.fileProcessStrategy = fileProcessStrategy;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getMoveNamePostfix() {
        return this.moveNamePostfix;
    }

    public void setMoveNamePostfix(String moveNamePostfix) {
        this.moveNamePostfix = moveNamePostfix;
    }

    public String getMoveNamePrefix() {
        return this.moveNamePrefix;
    }

    public void setMoveNamePrefix(String moveNamePrefix) {
        this.moveNamePrefix = moveNamePrefix;
    }

    public String[] getExcludedNamePrefixes() {
        return this.excludedNamePrefixes;
    }

    public void setExcludedNamePrefixes(String[] excludedNamePrefixes) {
        this.excludedNamePrefixes = excludedNamePrefixes;
    }

    public String[] getExcludedNamePostfixes() {
        return this.excludedNamePostfixes;
    }

    public void setExcludedNamePostfixes(String[] excludedNamePostfixes) {
        this.excludedNamePostfixes = excludedNamePostfixes;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isIgnoreFileNameHeader() {
        return this.ignoreFileNameHeader;
    }

    public void setIgnoreFileNameHeader(boolean ignoreFileNameHeader) {
        this.ignoreFileNameHeader = ignoreFileNameHeader;
    }

    protected FileProcessStrategy createFileStrategy() {
        if (this.isNoop()) {
            return new NoOpFileProcessStrategy();
        }
        if (this.moveNamePostfix != null || this.moveNamePrefix != null) {
            if (this.isDelete()) {
                throw new IllegalArgumentException("You cannot set the deleteFiles property and a moveFilenamePostfix or moveFilenamePrefix");
            }
            return new RenameFileProcessStrategy(this.isLock(), this.moveNamePrefix, this.moveNamePostfix);
        }
        if (this.isDelete()) {
            return new DeleteFileProcessStrategy(this.isLock());
        }
        return new RenameFileProcessStrategy(this.isLock());
    }
}

