/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.apache.camel.CamelException;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.util.UriUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfEndpointUtils {
    public static final String PROP_NAME_PORT = "port";
    public static final String PROP_NAME_SERVICE = "service";
    public static final String PROP_NAME_SERVICECLASS = "serviceClass";
    public static final String PROP_NAME_DATAFORMAT = "dataFormat";
    public static final String DATAFORMAT_POJO = "pojo";
    public static final String DATAFORMAT_MESSAGE = "message";
    public static final String DATAFORMAT_PAYLOAD = "payload";
    private static final Logger LOG = LogUtils.getL7dLogger(CxfEndpointUtils.class);

    private CxfEndpointUtils() {
    }

    static QName getQName(String name) {
        QName qName = null;
        if (name != null) {
            try {
                qName = QName.valueOf(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return qName;
    }

    public static QName getPortName(CxfEndpoint endpoint) {
        return CxfEndpointUtils.getQName(endpoint.getPortName());
    }

    public static QName getServiceName(CxfEndpoint endpoint) {
        return CxfEndpointUtils.getQName(endpoint.getServiceName());
    }

    public static EndpointInfo getEndpointInfo(Service service, CxfEndpoint endpoint) {
        EndpointInfo endpointInfo = null;
        Collection endpoints = ((ServiceInfo)service.getServiceInfos().get(0)).getEndpoints();
        if (endpoints.size() == 1) {
            endpointInfo = (EndpointInfo)endpoints.iterator().next();
        } else {
            String port = endpoint.getPortName();
            if (port != null) {
                QName endpointName = QName.valueOf(port);
                endpointInfo = ((ServiceInfo)service.getServiceInfos().get(0)).getEndpoint(endpointName);
            }
        }
        return endpointInfo;
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (null != cls.getAnnotation(WebService.class)) {
            return true;
        }
        for (Class<?> inf : cls.getInterfaces()) {
            if (null == inf.getAnnotation(WebService.class)) continue;
            return true;
        }
        return CxfEndpointUtils.hasWebServiceAnnotation(cls.getSuperclass());
    }

    public static ServerFactoryBean getServerFactoryBean(Class<?> cls) throws CamelException {
        try {
            boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
            JaxWsServerFactoryBean serverFactory = isJSR181SEnabled ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
            return serverFactory;
        }
        catch (Exception e) {
            throw new CamelException(e);
        }
    }

    public static ClientFactoryBean getClientFactoryBean(Class<?> cls) throws CamelException {
        try {
            boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
            JaxWsClientFactoryBean clientFactory = isJSR181SEnabled ? new JaxWsClientFactoryBean() : new ClientFactoryBean();
            return clientFactory;
        }
        catch (Exception e) {
            throw new CamelException(e);
        }
    }

    public static void checkEndpiontIntegration(CxfEndpoint endpoint, Bus bus) throws CamelException {
        String wsdlLocation = endpoint.getWsdlURL();
        QName serviceQName = CxfEndpointUtils.getQName(endpoint.getServiceName());
        String serviceClassName = endpoint.getServiceClass();
        DataFormat dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        URL wsdlUrl = null;
        if (wsdlLocation != null) {
            try {
                wsdlUrl = UriUtils.getWsdlUrl(new URI(wsdlLocation));
            }
            catch (Exception e) {
                throw new CamelException(e);
            }
        }
        if (serviceQName == null) {
            throw new CamelException(new Message("SVC_QNAME_NOT_FOUND_X", LOG, new Object[]{endpoint.getServiceName()}).toString());
        }
        if (serviceClassName == null && dataFormat == DataFormat.POJO) {
            throw new CamelException(new Message("SVC_CLASS_PROP_IS_REQUIRED_X", LOG, new Object[0]).toString());
        }
        WSDLServiceFactory serviceFactory = null;
        try {
            if (serviceClassName != null) {
                Class cls = ClassLoaderUtils.loadClass((String)serviceClassName, CxfEndpointUtils.class);
                boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
                serviceFactory = isJSR181SEnabled ? new JaxWsServiceFactoryBean() : new ReflectionServiceFactoryBean();
                serviceFactory.setBus(bus);
                if (wsdlUrl != null) {
                    ((ReflectionServiceFactoryBean)serviceFactory).setWsdlURL(wsdlUrl);
                }
                if (serviceQName != null) {
                    ((ReflectionServiceFactoryBean)serviceFactory).setServiceName(serviceQName);
                }
                ((ReflectionServiceFactoryBean)serviceFactory).setServiceClass(cls);
            } else {
                if (wsdlUrl == null) {
                    throw new CamelException(new Message("SVC_WSDL_URL_IS_NULL_X", LOG, new Object[]{wsdlLocation}).toString());
                }
                serviceFactory = new WSDLServiceFactory(bus, wsdlUrl, serviceQName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new CamelException(new Message("CLASS_X_NOT_FOUND ", LOG, new Object[]{serviceClassName}).toString(), cnfe);
        }
        catch (Exception e) {
            throw new CamelException(e);
        }
    }

    public static DataFormat getDataFormat(CxfEndpoint endpoint) throws CamelException {
        String dataFormatString = endpoint.getDataFormat();
        DataFormat retval = DataFormat.POJO;
        if (dataFormatString != null) {
            try {
                retval = DataFormat.valueOf(dataFormatString.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                throw new CamelException(new Message("INVALID_MESSAGE_FORMAT_XXXX", LOG, new Object[]{dataFormatString}).toString(), iae);
            }
        }
        return retval;
    }
}

