/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.interceptors.DOMInInterceptor;
import org.apache.camel.component.cxf.interceptors.DOMOutInterceptor;
import org.apache.camel.component.cxf.interceptors.PayloadContentRedirectInterceptor;
import org.apache.camel.component.cxf.interceptors.PayloadInInterceptor;
import org.apache.camel.component.cxf.invoker.AbstractInvokingContext;
import org.apache.camel.component.cxf.invoker.FaultChainInitiatorObserver;
import org.apache.camel.component.cxf.invoker.PayloadMessage;
import org.apache.camel.component.cxf.phase.FaultPayloadPhaseManagerImpl;
import org.apache.camel.component.cxf.phase.PayloadPhaseManagerImpl;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadInvokingContext
extends AbstractInvokingContext {
    private static final Logger LOG = Logger.getLogger(PayloadInvokingContext.class.getName());
    private PhaseManager phaseManager = new PayloadPhaseManagerImpl();
    private PhaseManager faultPhaseManager = new FaultPayloadPhaseManagerImpl();
    private MessageObserver inFaultObserver;
    private MessageObserver outFaultObserver;

    @Override
    public PhaseInterceptorChain getRequestOutInterceptorChain(Exchange exchange) {
        return this.getOutIntercepterChain(exchange);
    }

    @Override
    public PhaseInterceptorChain getResponseOutInterceptorChain(Exchange exchange) {
        return this.getOutIntercepterChain(exchange);
    }

    private PhaseInterceptorChain getOutIntercepterChain(Exchange exchange) {
        PhaseInterceptorChain chain = new PhaseInterceptorChain(new PayloadPhaseManagerImpl().getOutPhases());
        Bus bus = (Bus)exchange.get(Bus.class);
        assert (bus != null);
        List list = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + list);
        }
        chain.add((Collection)list);
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        if (endpoint != null) {
            list = endpoint.getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by endpoint: " + list);
            }
            chain.add((Collection)list);
            list = endpoint.getBinding().getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by binding: " + list);
            }
            chain.add((Collection)list);
        }
        chain.add((Interceptor)new DOMOutInterceptor());
        chain.add((Interceptor)new PayloadContentRedirectInterceptor());
        return chain;
    }

    @Override
    public void setRequestOutMessageContent(Message message, Object content) {
        PayloadMessage request = (PayloadMessage)content;
        Element header = request.getHeader();
        List<Element> payload = request.getPayload();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("header = " + header + ", paylaod = " + payload);
        }
        message.put(Element.class, (Object)header);
        message.put(List.class, payload);
    }

    @Override
    protected SortedSet<Phase> getInPhases() {
        return this.phaseManager.getInPhases();
    }

    protected SortedSet<Phase> getOutPhases() {
        return this.phaseManager.getOutPhases();
    }

    @Override
    protected List<Interceptor> getRoutingInterceptors() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        list.add((Interceptor)new DOMInInterceptor());
        list.add((Interceptor)new PayloadInInterceptor());
        return list;
    }

    @Override
    public Object getResponseObject(Exchange exchange, Map<String, Object> responseContext) {
        PayloadMessage payloadMsg = null;
        Message msg = exchange.getInMessage();
        List payload = this.getResponseObject(msg, responseContext, List.class);
        Element header = (Element)exchange.getInMessage().get(Element.class);
        payloadMsg = new PayloadMessage(payload, header);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(payloadMsg.toString());
        }
        return payloadMsg;
    }

    @Override
    protected <T> T getResponseObject(Message inMessage, Map<String, Object> responseContext, Class<T> clazz) {
        Object retval = null;
        if (inMessage != null) {
            if (null != responseContext) {
                responseContext.putAll((Map<String, Object>)inMessage);
                LOG.info("set responseContext to be" + responseContext);
            }
            retval = inMessage.get(clazz);
        }
        return (T)retval;
    }

    @Override
    protected PhaseInterceptorChain getInInterceptorChain(Exchange exchange, boolean isResponse) {
        Bus bus = (Bus)exchange.get(Bus.class);
        assert (bus != null);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(this.getInPhases());
        List<Interceptor> routingInterceptors = this.getRoutingInterceptors();
        chain.add(routingInterceptors);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Injected " + routingInterceptors);
        }
        List list = bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + list);
        }
        chain.add((Collection)list);
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        if (ep != null) {
            list = ep.getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by endpoint: " + list);
            }
            chain.add((Collection)list);
            list = ep.getBinding().getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by binding: " + list);
            }
            chain.add((Collection)list);
        }
        return chain;
    }

    @Override
    public void setEndpointFaultObservers(EndpointImpl endpointImpl, Bus bus) {
        if (this.inFaultObserver == null) {
            this.inFaultObserver = new FaultChainInitiatorObserver(bus, this.faultPhaseManager.getInPhases(), false);
        }
        endpointImpl.setInFaultObserver(this.inFaultObserver);
        if (this.outFaultObserver == null) {
            this.outFaultObserver = new FaultChainInitiatorObserver(bus, this.faultPhaseManager.getOutPhases(), true);
        }
        endpointImpl.setOutFaultObserver(this.outFaultObserver);
    }

    @Override
    public void setResponseContent(Message outMessage, Object resultPayload) {
        if (resultPayload != null) {
            PayloadMessage payloadMessage = (PayloadMessage)resultPayload;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(payloadMessage.toString());
            }
            outMessage.put(List.class, payloadMessage.getPayload());
            outMessage.put(Element.class, (Object)payloadMessage.getHeader());
        }
    }

    @Override
    public Object getRequestContent(Message inMessage) {
        List payload = (List)inMessage.get(List.class);
        Element header = (Element)inMessage.get(Element.class);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Header = " + header + ", Payload = " + payload);
        }
        return new PayloadMessage(payload, header);
    }
}

