/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpoint
extends DefaultEndpoint<CxfExchange> {
    private final CxfComponent component;
    private final String address;
    private String wsdlURL;
    private String serviceClass;
    private CxfBinding binding;
    private String portName;
    private String serviceName;
    private String dataFormat;
    private String beanId;
    private boolean isSpringContextEndpoint;
    private boolean inOut = true;
    private ConfigurerImpl configurer;
    private CxfEndpointBean cxfEndpointBean;

    public CxfEndpoint(String uri, String address, CxfComponent component) {
        super(uri, component);
        this.component = component;
        this.address = address;
        if (address.startsWith("bean:")) {
            this.isSpringContextEndpoint = true;
            this.beanId = address.substring("bean:".length());
            if (this.beanId.startsWith("//")) {
                this.beanId = this.beanId.substring(2);
            }
            SpringCamelContext context = (SpringCamelContext)this.getContext();
            this.configurer = new ConfigurerImpl(context.getApplicationContext());
            this.cxfEndpointBean = (CxfEndpointBean)((Object)context.getApplicationContext().getBean(this.beanId));
            assert (this.cxfEndpointBean != null);
        }
    }

    @Override
    public Producer<CxfExchange> createProducer() throws Exception {
        return new CxfProducer(this);
    }

    @Override
    public Consumer<CxfExchange> createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor);
    }

    @Override
    public CxfExchange createExchange() {
        return new CxfExchange(this.getContext(), this.getExchangePattern(), this.getBinding());
    }

    @Override
    public CxfExchange createExchange(ExchangePattern pattern) {
        return new CxfExchange(this.getContext(), pattern, this.getBinding());
    }

    public CxfExchange createExchange(Message inMessage) {
        return new CxfExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), inMessage);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String format) {
        this.dataFormat = format;
    }

    public boolean isSpringContextEndpoint() {
        return this.isSpringContextEndpoint;
    }

    public String getAddress() {
        return this.address;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String className) {
        this.serviceClass = className;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CxfBinding getBinding() {
        if (this.binding == null) {
            this.binding = new CxfBinding();
        }
        return this.binding;
    }

    public void setBinding(CxfBinding binding) {
        this.binding = binding;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    @Override
    public CxfComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public CxfEndpointBean getCxfEndpointBean() {
        return this.cxfEndpointBean;
    }

    public void configure(Object beanInstance) {
        this.configurer.configureBean(this.beanId, beanInstance);
    }
}

