/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.persistence.EntityExistsException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.bam.processor.NoCorrelationKeyException;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BamProcessorSupport<T>
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(BamProcessorSupport.class);
    private Class<T> entityType;
    private Class primaryKeyType = String.class;
    private Expression<Exchange> correlationKeyExpression;
    private TransactionTemplate transactionTemplate;
    private int maximumRetries = 30;

    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    public void setMaximumRetries(int maximumRetries) {
        this.maximumRetries = maximumRetries;
    }

    protected BamProcessorSupport(TransactionTemplate transactionTemplate, Expression<Exchange> correlationKeyExpression) {
        Type argumentType;
        ParameterizedType parameterizedType;
        Type[] arguments;
        this.transactionTemplate = transactionTemplate;
        this.correlationKeyExpression = correlationKeyExpression;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (argumentType = arguments[0]) instanceof Class) {
            this.entityType = (Class)argumentType;
        }
        if (this.entityType == null) {
            throw new IllegalArgumentException("Could not infer the entity type!");
        }
    }

    protected BamProcessorSupport(TransactionTemplate transactionTemplate, Expression<Exchange> correlationKeyExpression, Class<T> entitytype) {
        this.transactionTemplate = transactionTemplate;
        this.entityType = entitytype;
        this.correlationKeyExpression = correlationKeyExpression;
    }

    @Override
    public void process(final Exchange exchange) {
        Object entity = null;
        for (int i = 0; entity == null && i < this.maximumRetries; ++i) {
            if (i > 0) {
                LOG.info("Retry attempt due to duplicate row: " + i);
            }
            entity = this.transactionTemplate.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    try {
                        Object key = BamProcessorSupport.this.getCorrelationKey(exchange);
                        Object entity = BamProcessorSupport.this.loadEntity(exchange, key);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Correlation key: " + key + " with entity: " + entity);
                        }
                        BamProcessorSupport.this.processEntity(exchange, entity);
                        return entity;
                    }
                    catch (JpaSystemException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Likely exception is due to duplicate row in concurrent setting: " + (Object)((Object)e), e);
                        }
                        LOG.info("Attempt to insert duplicate row due to concurrency issue, so retrying: " + (Object)((Object)e));
                        return BamProcessorSupport.this.retryDueToDuplicate(status);
                    }
                    catch (DataIntegrityViolationException e) {
                        Throwable throwable = e.getCause();
                        if (throwable instanceof EntityExistsException) {
                            LOG.info("Attempt to insert duplicate row due to concurrency issue, so retrying: " + throwable);
                            return BamProcessorSupport.this.retryDueToDuplicate(status);
                        }
                        return BamProcessorSupport.this.onError(status, throwable);
                    }
                    catch (Throwable e) {
                        return BamProcessorSupport.this.onError(status, e);
                    }
                }
            });
        }
    }

    public Expression<Exchange> getCorrelationKeyExpression() {
        return this.correlationKeyExpression;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    protected abstract void processEntity(Exchange var1, T var2) throws Exception;

    protected abstract T loadEntity(Exchange var1, Object var2) throws Exception;

    protected abstract Class getKeyType();

    protected Object getCorrelationKey(Exchange exchange) throws NoCorrelationKeyException {
        Object value = this.correlationKeyExpression.evaluate(exchange);
        Class keyType = this.getKeyType();
        if (keyType != null) {
            value = ExchangeHelper.convertToType(exchange, keyType, value);
        }
        if (value == null) {
            throw new NoCorrelationKeyException(this, exchange);
        }
        return value;
    }

    protected Object retryDueToDuplicate(TransactionStatus status) {
        status.setRollbackOnly();
        return null;
    }

    protected Object onError(TransactionStatus status, Throwable e) {
        status.setRollbackOnly();
        LOG.error("Caught: " + e, e);
        throw new RuntimeCamelException(e);
    }
}

